/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens;

import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.characters.Crowbot;
import com.megacrit.cardcrawl.characters.Ironclad;
import com.megacrit.cardcrawl.characters.TheSilent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CharSelectInfo {
    public String name;
    public String flavorText;
    public String hp;
    public int gold;
    public int currentHp;
    public int maxHp;
    public int cardDraw;
    public int floorNum;
    public String levelName;
    public long saveDate;
    public AbstractPlayer.PlayerClass color;
    public String deckString;
    public ArrayList<String> relics;
    public ArrayList<String> deck;
    public boolean resumeGame;
    public boolean isHardMode;

    public CharSelectInfo(String name, String flavorText, int currentHp, int maxHp, int gold, int cardDraw, AbstractPlayer.PlayerClass color, ArrayList<String> relics, ArrayList<String> deck, boolean resumeGame) {
        this.name = name;
        this.flavorText = flavorText;
        this.currentHp = currentHp;
        this.maxHp = maxHp;
        this.hp = Integer.toString(currentHp) + "/" + Integer.toString(maxHp);
        this.gold = gold;
        this.cardDraw = cardDraw;
        this.relics = relics;
        this.deck = deck;
        this.color = color;
        this.resumeGame = resumeGame;
        if (!resumeGame) {
            this.setDeck();
        }
    }

    public CharSelectInfo(String name, String fText, int currentHp, int maxHp, int gold, int cardDraw, AbstractPlayer.PlayerClass color, ArrayList<String> relics, ArrayList<String> deck, long saveDate, int floorNum, String levelName, boolean isHardMode) {
        this(name, fText, currentHp, maxHp, gold, cardDraw, color, relics, deck, true);
        this.isHardMode = isHardMode;
        this.saveDate = saveDate;
        this.floorNum = floorNum;
        this.levelName = levelName;
    }

    private void setDeck() {
        switch (this.color) {
            case IRONCLAD: {
                this.deckString = CharSelectInfo.createDeckInfoString(Ironclad.getStartingDeck());
                break;
            }
            case THE_SILENT: {
                this.deckString = CharSelectInfo.createDeckInfoString(TheSilent.getStartingDeck());
                break;
            }
            case CROWBOT: {
                this.deckString = CharSelectInfo.createDeckInfoString(Crowbot.getStartingDeck());
            }
        }
    }

    public static String createDeckInfoString(ArrayList<String> deck) {
        HashMap<String, Integer> cards = new HashMap<String, Integer>();
        String retVal = "";
        for (String string : deck) {
            if (!cards.containsKey(string)) {
                cards.put(string, 1);
                continue;
            }
            cards.put(string, (Integer)cards.get(string) + 1);
        }
        for (Map.Entry entry : cards.entrySet()) {
            retVal = retVal + "#b" + entry.getValue() + " " + (String)entry.getKey();
            if ((Integer)entry.getValue() > 1) {
                retVal = retVal + "s";
            }
            retVal = retVal + ", ";
        }
        if (retVal.length() > 80) {
            return "Click the deck icon to view starting cards.";
        }
        return retVal.substring(0, retVal.length() - 2);
    }
}

