/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class ChooseOneScreen {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("ChooseOneScreen");
    public static final String[] TEXT = ChooseOneScreen.uiStrings.TEXT;
    private AbstractMonster target;
    private AbstractCard leftCard;
    private AbstractCard rightCard;
    private AbstractCard hoveredCard;
    private static final String CHOOSE_MSG = TEXT[0];

    public void update() {
        this.leftCard.update();
        this.rightCard.update();
        this.leftCard.updateHoverLogic();
        this.rightCard.updateHoverLogic();
        this.hoveredCard = this.leftCard.hb.hovered ? this.leftCard : (this.rightCard.hb.hovered ? this.rightCard : null);
        if (this.hoveredCard != null && InputHelper.justClickedLeft) {
            this.hoveredCard.use(AbstractDungeon.player, this.target);
            AbstractDungeon.closeCurrentScreen();
            InputHelper.justClickedLeft = false;
        }
    }

    public void render(SpriteBatch sb) {
        FontHelper.renderFontCentered(sb, FontHelper.kreon_32_special, CHOOSE_MSG, Settings.WIDTH / 2, (float)Settings.HEIGHT * 0.8f, Color.WHITE);
        if (this.leftCard.isSelected) {
            this.leftCard.render(sb, true);
        } else {
            this.leftCard.render(sb);
        }
        if (this.rightCard.isSelected) {
            this.rightCard.render(sb, true);
        } else {
            this.rightCard.render(sb);
        }
        this.leftCard.renderCardTip(sb);
        this.rightCard.renderCardTip(sb);
    }

    public void open(AbstractCard leftCard, AbstractCard rightCard, AbstractMonster target) {
        this.target = target;
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.CHOOSE_ONE;
        AbstractDungeon.overlayMenu.proceedButton.hide();
        AbstractDungeon.overlayMenu.showBlackScreen();
        this.leftCard = leftCard;
        this.rightCard = rightCard;
        this.placeCards();
    }

    private void placeCards() {
        this.leftCard.current_x = (float)Settings.WIDTH * 0.5f;
        this.rightCard.current_x = (float)Settings.WIDTH * 0.5f;
        this.leftCard.target_x = (float)Settings.WIDTH * 0.4f;
        this.rightCard.target_x = (float)Settings.WIDTH * 0.6f;
        this.leftCard.current_y = (float)Settings.HEIGHT * 0.5f;
        this.rightCard.current_y = (float)Settings.HEIGHT * 0.5f;
        this.leftCard.target_y = (float)Settings.HEIGHT * 0.5f;
        this.rightCard.target_y = (float)Settings.HEIGHT * 0.5f;
        this.leftCard.drawScale = 0.1f;
        this.rightCard.drawScale = 0.1f;
        this.leftCard.targetDrawScale = 0.75f;
        this.rightCard.targetDrawScale = 0.75f;
    }
}

