/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.metrics.LeaderboardPoster;
import com.megacrit.cardcrawl.metrics.Metrics;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.monsters.MonsterGroup;
import com.megacrit.cardcrawl.rooms.VictoryRoom;
import com.megacrit.cardcrawl.screens.GameOverStat;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveAndContinue;
import com.megacrit.cardcrawl.screens.stats.StatsScreen;
import com.megacrit.cardcrawl.ui.buttons.ReturnToMenuButton;
import com.megacrit.cardcrawl.unlock.AbstractUnlock;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.unlock.misc.TheSilentUnlock;
import com.megacrit.cardcrawl.vfx.DeathScreenFloatyEffect;
import com.megacrit.cardcrawl.vfx.UnlockTextEffect;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeathScreen {
    private static final Logger logger = LogManager.getLogger(DeathScreen.class.getName());
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("DeathScreen");
    public static final String[] TEXT = DeathScreen.uiStrings.TEXT;
    private MonsterGroup monsters = null;
    private String deathText;
    private ArrayList<DeathScreenFloatyEffect> particles = new ArrayList();
    private static final float NUM_PARTICLES = 50.0f;
    private float deathAnimWaitTimer = 1.0f;
    private static final float DEATH_TEXT_TIME = 5.0f;
    private float deathTextTimer = 5.0f;
    private Color defeatTextColor = Color.WHITE.cpy();
    private Color deathTextColor = Settings.BLUE_TEXT_COLOR.cpy();
    private static final float DEATH_TEXT_Y = (float)Settings.HEIGHT - 360.0f * Settings.scale;
    public ReturnToMenuButton returnButton;
    public ArrayList<GameOverStat> stats = new ArrayList();
    public ArrayList<AbstractUnlock> unlockBundle = null;
    public static long STINGER_ID = -999L;
    public static String STINGER_KEY = "";
    private boolean showingStats;
    private static final float STATS_TRANSITION_TIME = 0.5f;
    private static final float STAT_ANIM_INTERVAL = 0.1f;
    private static final float PROGRESS_BAR_ANIM_TIME = 2.0f;
    private float statsTimer = 0.0f;
    private float statAnimateTimer = 0.0f;
    private float progressBarTimer = 2.0f;
    private float progressBarAlpha = 0.0f;
    private long playTime;
    private static final float STAT_OFFSET_Y = 40.0f * Settings.scale;
    private static final float STAT_START_Y = (float)Settings.HEIGHT / 2.0f - 50.0f * Settings.scale;
    private int score = 0;
    private int unlockCost;
    private int nextUnlockCost;
    private int unlockLevel = 0;
    private boolean maxLevel = false;
    private float progressPercent;
    private float unlockTargetProgress;
    private float unlockTargetStart;
    private float unlockProgress;
    private static final int FLOOR_MULTIPLIER = 5;
    private static final int ENEMY_MULTIPLIER = 7;
    private static final int ELITE_MULTIPLIER = 15;
    private static final float GOLD_MULTIPLIER = 0.1f;
    private static final int ONE_BOSS_SCORE = 50;
    private static final int TWO_BOSS_SCORE = 100;
    private static final int THREE_BOSS_SCORE = 200;
    private boolean isVictory = false;
    private boolean playedWhir = false;
    private long whirId;
    private static int floorPoints;
    private static int monsterPoints;
    private static int elitePoints;
    private static int bossPoints;
    private static int goldPoints;
    private static int hpRatioPoints;

    public DeathScreen(MonsterGroup m) {
        AbstractDungeon.dungeonMapScreen.closeInstantly();
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.DEATH;
        AbstractDungeon.overlayMenu.showBlackScreen(1.0f);
        AbstractDungeon.previousScreen = null;
        AbstractDungeon.overlayMenu.cancelButton.hideInstantly();
        AbstractDungeon.isScreenUp = true;
        this.deathText = this.getDeathText();
        this.monsters = m;
        CardCrawlGame.sound.stop("BOSS_VICTORY_1");
        CardCrawlGame.sound.stop("BOSS_VICTORY_2");
        CardCrawlGame.sound.stop("BOSS_VICTORY_3");
        CardCrawlGame.sound.stop("BOSS_VICTORY_4");
        this.isVictory = AbstractDungeon.getCurrRoom() instanceof VictoryRoom;
        this.showingStats = false;
        this.returnButton = new ReturnToMenuButton();
        this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[0]);
        if (AbstractDungeon.getCurrRoom() instanceof VictoryRoom) {
            AbstractDungeon.dynamicBanner.appear(TEXT[1]);
        } else {
            AbstractDungeon.dynamicBanner.appear(this.getDeathBannerText());
        }
        if (AbstractDungeon.floorNum > 0) {
            CardCrawlGame.playerPref.putInteger(AbstractDungeon.player.chosenClass.name() + "_SPIRITS", AbstractDungeon.bossCount + CardCrawlGame.playerPref.getInteger(AbstractDungeon.player.chosenClass.name() + "_SPIRITS", 0));
            CardCrawlGame.playerPref.flush();
        } else {
            CardCrawlGame.playerPref.putInteger(AbstractDungeon.player.chosenClass.name() + "_SPIRITS", 0);
            AbstractDungeon.bossCount = 0;
        }
        CardCrawlGame.music.dispose();
        CardCrawlGame.sound.fadeOut(AbstractMonster.STINGER_KEY, AbstractMonster.STINGER_ID);
        int roll = MathUtils.random(0, 3);
        STINGER_KEY = roll == 0 ? "DEATH_1" : (roll == 1 ? "DEATH_2" : (roll == 2 ? "DEATH_3" : "DEATH_4"));
        STINGER_ID = CardCrawlGame.sound.play(STINGER_KEY, true);
        this.playTime = System.currentTimeMillis() / 1000L - AbstractDungeon.playtimeStart;
        if (this.isVictory) {
            switch (AbstractDungeon.player.chosenClass) {
                case IRONCLAD: {
                    UnlockTracker.unlockAchievement("RUBY");
                    break;
                }
                case THE_SILENT: {
                    UnlockTracker.unlockAchievement("EMERALD");
                    break;
                }
                case CROWBOT: {
                    break;
                }
            }
            this.submitVictoryMetrics();
            StatsScreen.updateVictoryTime(this.playTime);
            StatsScreen.incrementVictory(AbstractDungeon.player.chosenClass);
        } else {
            this.submitDefeatMetrics(m);
            StatsScreen.incrementDeath(AbstractDungeon.player.chosenClass);
        }
        this.defeatTextColor.a = 0.0f;
        this.deathTextColor.a = 0.0f;
        StatsScreen.incrementPlayTime(this.playTime);
        if (!Settings.isDailyRun && !Settings.isTrial) {
            StatsScreen.updateFurthestAscent(AbstractDungeon.floorNum);
            SaveAndContinue.deleteSave(AbstractDungeon.player.chosenClass);
        } else if (Settings.isDailyRun) {
            StatsScreen.updateHighestDailyScore(AbstractDungeon.floorNum);
        }
        this.calculateUnlockProgress();
        this.createGameOverStats();
    }

    private void createGameOverStats() {
        this.stats.clear();
        this.stats.add(new GameOverStat(TEXT[2] + " (" + AbstractDungeon.floorNum + ")", Integer.toString(floorPoints)));
        this.stats.add(new GameOverStat(TEXT[43] + " (" + CardCrawlGame.monstersSlain + ")", Integer.toString(monsterPoints)));
        this.stats.add(new GameOverStat(TEXT[44] + " (" + CardCrawlGame.elitesSlain + ")", Integer.toString(elitePoints)));
        this.stats.add(new GameOverStat(TEXT[3] + " (" + AbstractDungeon.bossCount + ")", Integer.toString(bossPoints)));
        if (this.isVictory) {
            this.stats.add(new GameOverStat(TEXT[45] + " (" + AbstractDungeon.player.gold + ")", Integer.toString(goldPoints)));
            this.stats.add(new GameOverStat(TEXT[46] + " (" + MathUtils.round((float)AbstractDungeon.player.currentHealth * 100.0f / (float)AbstractDungeon.player.maxHealth) + "%)", Integer.toString(hpRatioPoints)));
        }
        this.stats.add(new GameOverStat());
        this.stats.add(new GameOverStat(TEXT[6], Integer.toString(this.score)));
    }

    private void calculateUnlockProgress() {
        this.score = DeathScreen.calcScore(this.isVictory);
        this.unlockLevel = UnlockTracker.getUnlockLevel(AbstractDungeon.player.chosenClass);
        if (this.unlockLevel >= 6) {
            this.maxLevel = true;
            return;
        }
        if (this.score == 0) {
            this.playedWhir = true;
        }
        this.unlockTargetStart = this.unlockProgress = (float)UnlockTracker.getCurrentProgress(AbstractDungeon.player.chosenClass);
        this.unlockCost = UnlockTracker.getCurrentScoreCost(AbstractDungeon.player.chosenClass);
        this.unlockTargetProgress = this.unlockProgress + (float)this.score;
        this.nextUnlockCost = UnlockTracker.incrementUnlockRamp(this.unlockCost);
        if (this.unlockTargetProgress >= (float)this.unlockCost) {
            this.unlockBundle = UnlockTracker.getUnlockBundle(AbstractDungeon.player.chosenClass, this.unlockLevel);
            if (this.unlockLevel == 5) {
                this.unlockTargetProgress = this.unlockCost;
            } else if (this.unlockTargetProgress > (float)this.unlockCost - this.unlockProgress + (float)this.nextUnlockCost - 1.0f) {
                this.unlockTargetProgress = (float)this.unlockCost - this.unlockProgress + (float)this.nextUnlockCost - 1.0f;
            }
        }
        logger.info("SCOR: " + this.score);
        logger.info("PROG: " + this.unlockProgress);
        logger.info("STRT: " + this.unlockTargetStart);
        logger.info("TRGT: " + this.unlockTargetProgress);
        logger.info("COST: " + this.unlockCost);
        UnlockTracker.addScore(AbstractDungeon.player.chosenClass, this.score);
        this.progressPercent = this.unlockTargetStart / (float)this.unlockCost;
    }

    public static int calcScore(boolean victory) {
        floorPoints = 0;
        monsterPoints = 0;
        elitePoints = 0;
        bossPoints = 0;
        goldPoints = 0;
        hpRatioPoints = 0;
        int tmp = AbstractDungeon.floorNum * 5;
        floorPoints = AbstractDungeon.floorNum * 5;
        monsterPoints = CardCrawlGame.monstersSlain * 7;
        elitePoints = CardCrawlGame.elitesSlain * 15;
        tmp += monsterPoints;
        tmp += elitePoints;
        if (victory) {
            goldPoints = (int)((float)goldPoints + (float)AbstractDungeon.player.gold * 0.1f);
            tmp += goldPoints;
            hpRatioPoints = MathUtils.round((float)AbstractDungeon.player.currentHealth * 100.0f / (float)AbstractDungeon.player.maxHealth);
            tmp += hpRatioPoints;
        }
        switch (AbstractDungeon.bossCount) {
            case 1: {
                tmp += 50;
                bossPoints = 50;
                break;
            }
            case 2: {
                tmp += 100;
                bossPoints = 100;
                break;
            }
            case 3: {
                tmp += 200;
                bossPoints = 200;
                break;
            }
        }
        return tmp;
    }

    private void submitDefeatMetrics(MonsterGroup m) {
        if (!Settings.UPLOAD_DATA) {
            return;
        }
        if (m != null && !m.areMonstersDead() && !m.areMonstersBasicallyDead()) {
            CardCrawlGame.metricData.addEncounterData();
        }
        Metrics metrics = new Metrics();
        metrics.setValues(true, m, Metrics.MetricRequestType.UPLOAD_METRICS);
        metrics.gatherAllDataAndSave(true, m);
        Thread t = new Thread(metrics);
        t.start();
        LeaderboardPoster poster = new LeaderboardPoster();
        poster.setValues(LeaderboardPoster.LeaderboardDataType.VICTORY_DATA, null, null, null, true);
        Thread t2 = new Thread(poster);
        t2.start();
        if (Settings.isDailyRun) {
            LeaderboardPoster poster2 = new LeaderboardPoster();
            poster2.setValues(LeaderboardPoster.LeaderboardDataType.DAILY_DATA, null, null, null, false);
            Thread t3 = new Thread(poster2);
            t3.start();
        }
    }

    private void submitVictoryMetrics() {
        if (!Settings.UPLOAD_DATA) {
            return;
        }
        Metrics metrics = new Metrics();
        metrics.setValues(false, null, Metrics.MetricRequestType.UPLOAD_METRICS);
        metrics.gatherAllDataAndSave(false, null);
        Thread t = new Thread(metrics);
        t.start();
        if (!Settings.isDailyRun && !Settings.isTrial) {
            StatsScreen.updateFurthestAscent(AbstractDungeon.floorNum);
            SaveAndContinue.deleteSave(AbstractDungeon.player.chosenClass);
        }
    }

    private String getDeathBannerText() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TEXT[7]);
        list.add(TEXT[8]);
        list.add(TEXT[9]);
        list.add(TEXT[10]);
        list.add(TEXT[11]);
        list.add(TEXT[12]);
        list.add(TEXT[13]);
        list.add(TEXT[14]);
        return (String)list.get(MathUtils.random(list.size() - 1));
    }

    private String getDeathText() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TEXT[15]);
        list.add(TEXT[16]);
        list.add(TEXT[17]);
        list.add(TEXT[18]);
        list.add(TEXT[19]);
        list.add(TEXT[20]);
        list.add(TEXT[21]);
        list.add(TEXT[22]);
        list.add(TEXT[23]);
        list.add(TEXT[24]);
        list.add(TEXT[25]);
        list.add(TEXT[26]);
        list.add(TEXT[27]);
        list.add(TEXT[28]);
        list.add(TEXT[29]);
        if (AbstractDungeon.player.chosenClass == AbstractPlayer.PlayerClass.THE_SILENT) {
            list.add("...");
        }
        return (String)list.get(MathUtils.random(list.size() - 1));
    }

    public void hide() {
        this.returnButton.hide();
        AbstractDungeon.dynamicBanner.hide();
    }

    public void reopen() {
        this.reopen(false);
    }

    public void reopen(boolean fromVictoryUnlock) {
        AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.DEATH;
        this.statsTimer = 0.5f;
        if (this.isVictory) {
            AbstractDungeon.dynamicBanner.appearInstantly(TEXT[1]);
        } else {
            AbstractDungeon.dynamicBanner.appearInstantly(TEXT[30]);
        }
        AbstractDungeon.overlayMenu.showBlackScreen(1.0f);
        if (fromVictoryUnlock) {
            this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[31]);
        } else if (!this.showingStats) {
            this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[32]);
        } else if (this.unlockBundle == null) {
            if (!this.isVictory) {
                if (UnlockTracker.isCharacterLocked("The Silent")) {
                    this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[40]);
                } else {
                    this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[34]);
                }
            } else {
                this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[35]);
            }
        } else {
            this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[36]);
        }
    }

    public void update() {
        if (Settings.isDebug && InputHelper.justClickedRight) {
            UnlockTracker.resetUnlockProgress(AbstractDungeon.player.chosenClass);
        }
        this.returnButton.update();
        if (this.returnButton.hb.clicked) {
            this.returnButton.hb.clicked = false;
            if (!this.showingStats) {
                this.showingStats = true;
                this.statsTimer = 0.5f;
                logger.info("Clicked");
                this.returnButton = new ReturnToMenuButton();
                if (this.unlockBundle == null) {
                    if (!this.isVictory) {
                        if (UnlockTracker.isCharacterLocked("The Silent")) {
                            this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[40]);
                        } else {
                            this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[37]);
                        }
                    } else {
                        this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[39]);
                    }
                } else {
                    this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[40]);
                }
            } else if (this.unlockBundle != null) {
                AbstractDungeon.gUnlockScreen.open(this.unlockBundle);
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.DEATH;
                AbstractDungeon.screen = AbstractDungeon.CurrentScreen.GASHA_UNLOCK;
                this.unlockBundle = null;
                if (UnlockTracker.isCharacterLocked("The Silent")) {
                    this.returnButton.appear((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT * 0.15f, TEXT[40]);
                } else {
                    this.returnButton.label = TEXT[37];
                }
            } else if (this.isVictory) {
                this.returnButton.hide();
                if (AbstractDungeon.unlocks.isEmpty() || Settings.isDemo) {
                    if (Settings.isDemo) {
                        CardCrawlGame.startOver();
                    } else if (UnlockTracker.isCharacterLocked("The Silent")) {
                        AbstractDungeon.unlocks.add(new TheSilentUnlock());
                        AbstractDungeon.unlockScreen.open(AbstractDungeon.unlocks.remove(0));
                    } else {
                        CardCrawlGame.startOverButShowCredits();
                    }
                } else {
                    AbstractDungeon.unlocks.clear();
                    CardCrawlGame.startOverButShowCredits();
                }
            } else {
                this.returnButton.hide();
                if (AbstractDungeon.unlocks.isEmpty() || Settings.isDemo) {
                    if (UnlockTracker.isCharacterLocked("The Silent")) {
                        AbstractDungeon.unlocks.add(new TheSilentUnlock());
                        AbstractDungeon.unlockScreen.open(AbstractDungeon.unlocks.remove(0));
                    } else {
                        CardCrawlGame.startOver();
                    }
                } else {
                    AbstractDungeon.unlocks.clear();
                    CardCrawlGame.startOverButShowCredits();
                }
            }
        }
        this.updateStatsScreen();
        if (this.deathAnimWaitTimer != 0.0f) {
            this.deathAnimWaitTimer -= Gdx.graphics.getDeltaTime();
            if (this.deathAnimWaitTimer < 0.0f) {
                this.deathAnimWaitTimer = 0.0f;
                AbstractDungeon.player.playDeathAnimation();
            }
        } else {
            this.deathTextTimer -= Gdx.graphics.getDeltaTime();
            if (this.deathTextTimer < 0.0f) {
                this.deathTextTimer = 0.0f;
            }
            this.deathTextColor.a = Interpolation.fade.apply(0.0f, 1.0f, 1.0f - this.deathTextTimer / 5.0f);
            this.defeatTextColor.a = Interpolation.fade.apply(0.0f, 1.0f, 1.0f - this.deathTextTimer / 5.0f);
        }
        if (this.monsters != null) {
            this.monsters.update();
            this.monsters.updateAnimations();
        }
        if ((float)this.particles.size() < 50.0f) {
            this.particles.add(new DeathScreenFloatyEffect());
        }
    }

    private void updateStatsScreen() {
        if (Settings.isDebug && InputHelper.justClickedRight) {
            AbstractDungeon.topLevelEffects.add(new UnlockTextEffect());
        }
        if (this.showingStats) {
            this.progressBarAlpha = MathHelper.slowColorLerpSnap(this.progressBarAlpha, 1.0f);
            this.statsTimer -= Gdx.graphics.getDeltaTime();
            if (this.statsTimer < 0.0f) {
                this.statsTimer = 0.0f;
            }
            this.returnButton.y = Interpolation.pow3In.apply((float)Settings.HEIGHT * 0.1f, (float)Settings.HEIGHT * 0.15f, this.statsTimer * 1.0f / 0.5f);
            AbstractDungeon.dynamicBanner.y = Interpolation.pow3In.apply((float)Settings.HEIGHT - 220.0f * Settings.scale, (float)Settings.HEIGHT - 280.0f * Settings.scale, this.statsTimer * 1.0f / 0.5f);
            for (GameOverStat i : this.stats) {
                i.update();
            }
            if (this.statAnimateTimer < 0.0f) {
                boolean allStatsShown = true;
                for (GameOverStat i : this.stats) {
                    if (!i.hidden) continue;
                    i.hidden = false;
                    this.statAnimateTimer = 0.1f;
                    allStatsShown = false;
                    break;
                }
                if (allStatsShown) {
                    this.animateProgressBar();
                }
            } else {
                this.statAnimateTimer -= Gdx.graphics.getDeltaTime();
            }
        }
    }

    private void animateProgressBar() {
        if (this.maxLevel) {
            return;
        }
        this.progressBarTimer -= Gdx.graphics.getDeltaTime();
        if (this.progressBarTimer < 0.0f) {
            this.progressBarTimer = 0.0f;
        }
        if (this.progressBarTimer > 2.0f) {
            return;
        }
        if (!this.playedWhir) {
            this.playedWhir = true;
            this.whirId = CardCrawlGame.sound.play("UNLOCK_WHIR");
        }
        this.unlockProgress = Interpolation.pow2In.apply(this.unlockTargetProgress, this.unlockTargetStart, this.progressBarTimer / 2.0f);
        if (this.unlockProgress >= (float)this.unlockCost && this.unlockLevel != 6) {
            if (this.unlockLevel == 5) {
                this.unlockProgress = this.unlockCost;
                ++this.unlockLevel;
                AbstractDungeon.topLevelEffects.add(new UnlockTextEffect());
            } else {
                this.unlockTargetProgress = (float)this.score - ((float)this.unlockCost - this.unlockTargetStart);
                this.progressBarTimer = 3.0f;
                AbstractDungeon.topLevelEffects.add(new UnlockTextEffect());
                CardCrawlGame.sound.stop("UNLOCK_WHIR", this.whirId);
                this.playedWhir = false;
                this.unlockProgress = 0.0f;
                this.unlockTargetStart = 0.0f;
                if (this.unlockTargetProgress > (float)(this.nextUnlockCost - 1)) {
                    this.unlockTargetProgress = this.nextUnlockCost - 1;
                }
                this.unlockCost = this.nextUnlockCost;
                ++this.unlockLevel;
            }
        }
        this.progressPercent = this.unlockProgress / (float)this.unlockCost;
    }

    public void render(SpriteBatch sb) {
        Iterator<DeathScreenFloatyEffect> i = this.particles.iterator();
        while (i.hasNext()) {
            DeathScreenFloatyEffect e = i.next();
            if (e.renderBehind) {
                e.render(sb);
            }
            e.update();
            if (!e.isDone) continue;
            i.remove();
        }
        AbstractDungeon.player.render(sb);
        if (this.monsters != null) {
            this.monsters.render(sb);
        }
        sb.setBlendFunction(770, 1);
        for (DeathScreenFloatyEffect e : this.particles) {
            if (e.renderBehind) continue;
            e.render(sb);
        }
        sb.setBlendFunction(770, 771);
        this.renderStatsScreen(sb);
        if (!this.showingStats && !this.isVictory) {
            FontHelper.renderFontCentered(sb, FontHelper.topPanelInfoFont, this.deathText, (float)Settings.WIDTH / 2.0f, DEATH_TEXT_Y, this.deathTextColor);
        }
        this.returnButton.render(sb);
    }

    private void renderStatsScreen(SpriteBatch sb) {
        if (this.showingStats) {
            sb.setColor(new Color(0.0f, 0.0f, 0.0f, (1.0f - this.statsTimer) * 0.6f));
            sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
            float y = STAT_START_Y + (float)this.stats.size() * STAT_OFFSET_Y / 2.0f;
            for (GameOverStat i : this.stats) {
                i.render(sb, y);
                y -= STAT_OFFSET_Y;
            }
            this.renderProgressBar(sb);
        }
    }

    private void renderProgressBar(SpriteBatch sb) {
        if (this.maxLevel) {
            return;
        }
        sb.setColor(new Color(1.0f, 1.0f, 1.0f, this.progressBarAlpha * 0.3f));
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 576.0f * Settings.scale, (float)Settings.HEIGHT * 0.2f, 768.0f * Settings.scale, 14.0f * Settings.scale);
        sb.setColor(new Color(1.0f, 0.8f, 0.3f, this.progressBarAlpha * 0.9f));
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 576.0f * Settings.scale, (float)Settings.HEIGHT * 0.2f, 768.0f * Settings.scale * this.progressPercent, 14.0f * Settings.scale);
        sb.setColor(new Color(0.0f, 0.0f, 0.0f, this.progressBarAlpha * 0.25f));
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 576.0f * Settings.scale, (float)Settings.HEIGHT * 0.2f, 768.0f * Settings.scale * this.progressPercent, 4.0f * Settings.scale);
        String derp = "[" + (int)this.unlockProgress + "/" + this.unlockCost + "]";
        Color tColor = Settings.CREAM_COLOR.cpy();
        tColor.a = this.progressBarAlpha * 0.9f;
        FontHelper.renderFontLeftTopAligned(sb, FontHelper.topPanelInfoFont, derp, 576.0f * Settings.scale, (float)Settings.HEIGHT * 0.2f - 12.0f * Settings.scale, tColor);
        derp = 6 - this.unlockLevel == 1 ? TEXT[42] + (6 - this.unlockLevel) : TEXT[41] + (6 - this.unlockLevel);
        FontHelper.renderFontRightTopAligned(sb, FontHelper.topPanelInfoFont, derp, 1344.0f * Settings.scale, (float)Settings.HEIGHT * 0.2f - 12.0f * Settings.scale, tColor);
    }
}

