/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import java.util.ArrayList;

public class DiscardPileViewScreen {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("DiscardPileViewScreen");
    public static final String[] TEXT = DiscardPileViewScreen.uiStrings.TEXT;
    public boolean isHovered = false;
    private static final int CARDS_PER_LINE = 5;
    private boolean grabbedScreen = false;
    private float grabStartY = 0.0f;
    private float currentDiffY = 0.0f;
    private static float drawStartX;
    private static float drawStartY;
    private static float padX;
    private static float padY;
    private float scrollLowerBound = -Settings.DEFAULT_SCROLL_LIMIT;
    private float scrollUpperBound = Settings.DEFAULT_SCROLL_LIMIT;
    private static final String HEADER_INFO;
    private AbstractCard hoveredCard = null;
    private int prevDeckSize = 0;

    public DiscardPileViewScreen() {
        drawStartX = Settings.WIDTH;
        drawStartX -= 5.0f * AbstractCard.IMG_WIDTH * 0.75f;
        drawStartX -= 4.0f * Settings.CARD_VIEW_PAD_X;
        drawStartX /= 2.0f;
        drawStartX += AbstractCard.IMG_WIDTH * 0.75f / 2.0f;
        padX = AbstractCard.IMG_WIDTH * 0.75f + Settings.CARD_VIEW_PAD_X;
        padY = AbstractCard.IMG_HEIGHT * 0.75f + Settings.CARD_VIEW_PAD_Y;
    }

    public void update() {
        this.updateScrolling();
        this.updatePositions();
    }

    private void updatePositions() {
        this.hoveredCard = null;
        int lineNum = 0;
        ArrayList<AbstractCard> cards = AbstractDungeon.player.discardPile.group;
        for (int i = 0; i < cards.size(); ++i) {
            int mod = i % 5;
            if (mod == 0 && i != 0) {
                ++lineNum;
            }
            cards.get((int)i).target_x = drawStartX + (float)mod * padX;
            cards.get((int)i).target_y = drawStartY + this.currentDiffY - (float)lineNum * padY;
            cards.get(i).update();
            cards.get(i).updateHoverLogic();
            if (!cards.get((int)i).hb.hovered) continue;
            this.hoveredCard = cards.get(i);
        }
    }

    private void updateScrolling() {
        int y = InputHelper.mY;
        if (!this.grabbedScreen) {
            if (InputHelper.scrolledDown) {
                this.currentDiffY += Settings.SCROLL_SPEED;
            } else if (InputHelper.scrolledUp) {
                this.currentDiffY -= Settings.SCROLL_SPEED;
            }
            if (InputHelper.justClickedLeft) {
                this.grabbedScreen = true;
                this.grabStartY = (float)y - this.currentDiffY;
            }
        } else if (InputHelper.isMouseDown) {
            this.currentDiffY = (float)y - this.grabStartY;
        } else {
            this.grabbedScreen = false;
        }
        if (this.prevDeckSize != AbstractDungeon.player.discardPile.size()) {
            this.calculateScrollBounds();
        }
        this.resetScrolling();
    }

    private void calculateScrollBounds() {
        int scrollTmp = 0;
        if (AbstractDungeon.player.discardPile.size() > 10) {
            scrollTmp = AbstractDungeon.player.discardPile.size() / 5 - 2;
            if (AbstractDungeon.player.discardPile.size() % 5 != 0) {
                ++scrollTmp;
            }
            this.scrollUpperBound = Settings.DEFAULT_SCROLL_LIMIT + (float)scrollTmp * padY;
        } else {
            this.scrollUpperBound = Settings.DEFAULT_SCROLL_LIMIT;
        }
        this.prevDeckSize = AbstractDungeon.player.discardPile.size();
    }

    private void resetScrolling() {
        if (this.currentDiffY < this.scrollLowerBound) {
            this.currentDiffY = MathHelper.scrollSnapLerpSpeed(this.currentDiffY, this.scrollLowerBound);
        } else if (this.currentDiffY > this.scrollUpperBound) {
            this.currentDiffY = MathHelper.scrollSnapLerpSpeed(this.currentDiffY, this.scrollUpperBound);
        }
    }

    public void open() {
        CardCrawlGame.sound.play("DECK_OPEN");
        AbstractDungeon.overlayMenu.showBlackScreen();
        this.currentDiffY = 0.0f;
        this.grabStartY = 0.0f;
        this.grabbedScreen = false;
        AbstractDungeon.isScreenUp = true;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.DISCARD_VIEW;
        for (AbstractCard c : AbstractDungeon.player.discardPile.group) {
            c.setAngle(0.0f, true);
            c.targetDrawScale = 0.75f;
            c.targetDrawScale = 0.75f;
            c.drawScale = 0.75f;
            c.lighten(true);
        }
        this.hideCards();
        AbstractDungeon.overlayMenu.cancelButton.show(TEXT[1]);
        drawStartY = AbstractDungeon.player.discardPile.group.size() <= 5 ? (float)Settings.HEIGHT * 0.5f : (float)Settings.HEIGHT * 0.66f;
        this.calculateScrollBounds();
    }

    private void hideCards() {
        int lineNum = 0;
        ArrayList<AbstractCard> cards = AbstractDungeon.player.discardPile.group;
        for (int i = 0; i < cards.size(); ++i) {
            int mod = i % 5;
            if (mod == 0 && i != 0) {
                ++lineNum;
            }
            cards.get((int)i).current_x = drawStartX + (float)mod * padX;
            cards.get((int)i).current_y = drawStartY + this.currentDiffY - (float)lineNum * padY - MathUtils.random(100.0f * Settings.scale, 200.0f * Settings.scale);
        }
    }

    public void render(SpriteBatch sb) {
        if (this.hoveredCard == null) {
            AbstractDungeon.player.discardPile.render(sb);
        } else {
            AbstractDungeon.player.discardPile.renderExceptOneCard(sb, this.hoveredCard);
            this.hoveredCard.renderHoverShadow(sb);
            this.hoveredCard.render(sb);
            this.hoveredCard.renderCardTip(sb);
        }
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.DISCARD_PILE_BANNER, 1290.0f * Settings.scale, 0.0f, 630.0f * Settings.scale, 128.0f * Settings.scale);
        FontHelper.renderFontLeftTopAligned(sb, FontHelper.deckBannerFont, TEXT[2], 1558.0f * Settings.scale, 82.0f * Settings.scale, new Color(1.0f, 1.0f, 0.75f, 1.0f));
        FontHelper.renderDeckViewTip(sb, HEADER_INFO, 96.0f * Settings.scale, Settings.CREAM_COLOR);
        AbstractDungeon.overlayMenu.discardPilePanel.render(sb);
    }

    static {
        HEADER_INFO = TEXT[0];
    }
}

