/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.mainMenu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.localization.UIStrings;

public class CardLibSortHeader {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("CardLibSortHeader");
    public static final String[] TEXT = CardLibSortHeader.uiStrings.TEXT;
    private CardGroup group;
    private Hitbox rarityHb = new Hitbox(200.0f * Settings.scale, 80.0f * Settings.scale);
    private Hitbox typeHb = new Hitbox(200.0f * Settings.scale, 80.0f * Settings.scale);
    private Hitbox alphaHb = new Hitbox(200.0f * Settings.scale, 80.0f * Settings.scale);
    private boolean rarityAscending = false;
    private boolean typeAscending = false;
    private boolean alphaAscending = false;
    public boolean justSorted = false;
    private static final float START_X = 700.0f * Settings.scale;
    private static final float SPACE_X = 220.0f * Settings.scale;

    public CardLibSortHeader(CardGroup group) {
        this.group = group;
        this.rarityHb.move(START_X, 0.0f);
        this.typeHb.move(START_X + SPACE_X, 0.0f);
        this.alphaHb.move(START_X + SPACE_X * 2.0f, 0.0f);
    }

    public void update() {
        this.rarityHb.update();
        this.typeHb.update();
        this.alphaHb.update();
        if (this.rarityHb.justHovered || this.typeHb.justHovered || this.alphaHb.justHovered) {
            CardCrawlGame.sound.playA("UI_HOVER", -0.3f);
        }
        if (this.rarityHb.hovered && InputHelper.justClickedLeft) {
            this.rarityHb.clickStarted = true;
        } else if (this.typeHb.hovered && InputHelper.justClickedLeft) {
            this.typeHb.clickStarted = true;
        } else if (this.alphaHb.hovered && InputHelper.justClickedLeft) {
            this.alphaHb.clickStarted = true;
        }
        if (this.rarityHb.clicked) {
            this.rarityHb.clicked = false;
            this.rarityAscending = !this.rarityAscending;
            this.group.sortByRarity(this.rarityAscending);
            this.group.sortByStatus(false);
            this.justSorted = true;
            CardCrawlGame.sound.playA("UI_CLICK_1", -0.2f);
        }
        if (this.typeHb.clicked) {
            this.typeHb.clicked = false;
            this.typeAscending = !this.typeAscending;
            this.group.sortByType(this.typeAscending);
            this.group.sortByStatus(false);
            this.justSorted = true;
            CardCrawlGame.sound.playA("UI_CLICK_1", -0.2f);
        }
        if (this.alphaHb.clicked) {
            this.alphaHb.clicked = false;
            this.alphaAscending = !this.alphaAscending;
            this.group.sortAlphabetically(this.alphaAscending);
            this.group.sortByStatus(false);
            this.justSorted = true;
            CardCrawlGame.sound.playA("UI_CLICK_1", -0.2f);
        }
    }

    public void render(SpriteBatch sb) {
        this.rarityHb.move(this.rarityHb.cX, this.group.getBottomCard().current_y + 230.0f * Settings.scale);
        this.typeHb.move(this.typeHb.cX, this.rarityHb.cY);
        this.alphaHb.move(this.alphaHb.cX, this.rarityHb.cY);
        Color c = this.rarityHb.hovered ? Settings.GOLD_COLOR : Settings.CREAM_COLOR;
        FontHelper.renderFontCentered(sb, FontHelper.topPanelInfoFont, TEXT[0], this.rarityHb.cX, this.rarityHb.cY, c);
        sb.setColor(c);
        sb.draw(ImageMaster.FILTER_ARROW, this.rarityHb.cX - 16.0f + 60.0f * Settings.scale, this.rarityHb.cY - 16.0f, 16.0f, 16.0f, 32.0f, 32.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 32, 32, false, !this.rarityAscending);
        c = this.typeHb.hovered ? Settings.GOLD_COLOR : Settings.CREAM_COLOR;
        FontHelper.renderFontCentered(sb, FontHelper.topPanelInfoFont, TEXT[1], this.typeHb.cX, this.typeHb.cY, c);
        sb.setColor(c);
        sb.draw(ImageMaster.FILTER_ARROW, this.typeHb.cX - 16.0f + 50.0f * Settings.scale, this.typeHb.cY - 16.0f, 16.0f, 16.0f, 32.0f, 32.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 32, 32, false, !this.typeAscending);
        c = this.alphaHb.hovered ? Settings.GOLD_COLOR : Settings.CREAM_COLOR;
        FontHelper.renderFontCentered(sb, FontHelper.topPanelInfoFont, TEXT[2], this.alphaHb.cX, this.alphaHb.cY, c);
        sb.setColor(c);
        sb.draw(ImageMaster.FILTER_ARROW, this.alphaHb.cX - 16.0f + 50.0f * Settings.scale, this.alphaHb.cY - 16.0f, 16.0f, 16.0f, 32.0f, 32.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 32, 32, false, !this.alphaAscending);
        this.alphaHb.render(sb);
        this.rarityHb.render(sb);
        this.typeHb.render(sb);
    }
}

