/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.mainMenu;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.screens.mainMenu.MenuCancelButton;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

public class PatchNotesScreen {
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("PatchNotesScreen");
    public static final String[] TEXT = PatchNotesScreen.uiStrings.TEXT;
    private static final String LOGS_DIR = "changelog" + File.separator + "notes.txt";
    private static String text = null;
    private FileHandle log;
    private static final float START_Y = (float)Settings.HEIGHT - 300.0f * Settings.scale;
    private float scrollY;
    private float targetY;
    private float scrollLowerBound;
    private float scrollUpperBound;
    public MenuCancelButton button;
    private boolean grabbedScreen;
    private float grabStartY;

    public PatchNotesScreen() {
        this.targetY = this.scrollY = START_Y;
        this.scrollLowerBound = 1000.0f * Settings.scale;
        this.scrollUpperBound = 2400.0f * Settings.scale;
        this.button = new MenuCancelButton();
        this.grabbedScreen = false;
        this.grabStartY = 0.0f;
    }

    public void open() {
        this.button.show(TEXT[0]);
        this.targetY = (float)Settings.HEIGHT - 100.0f * Settings.scale;
        this.scrollY = (float)Settings.HEIGHT - 400.0f * Settings.scale;
        CardCrawlGame.mainMenuScreen.darken();
        CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.PATCH_NOTES;
        if (text == null) {
            this.log = Gdx.files.internal(LOGS_DIR);
            this.openLog();
            this.scrollUpperBound = 300.0f * Settings.scale - FontHelper.getSmartHeight(FontHelper.panelNameTitleFont, text, 1600.0f * Settings.scale, 30.0f * Settings.scale);
            this.scrollLowerBound = (float)Settings.HEIGHT - 300.0f * Settings.scale;
            if (this.scrollUpperBound < this.scrollLowerBound) {
                this.scrollUpperBound = this.scrollLowerBound + 100.0f * Settings.scale;
            }
        } else {
            this.targetY = this.scrollY = START_Y;
        }
    }

    private void openLog() {
        try (BufferedReader br = new BufferedReader(this.log.reader());){
            StringBuilder sb = new StringBuilder();
            String line = "";
            try {
                line = br.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            while (line != null) {
                sb.append(" NL " + line);
                sb.append(System.lineSeparator());
                line = br.readLine();
            }
            text = sb.toString();
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.scrollUpperBound = 300.0f * Settings.scale - FontHelper.getSmartHeight(FontHelper.panelNameTitleFont, text, 1600.0f * Settings.scale, 30.0f * Settings.scale);
        this.scrollLowerBound = (float)Settings.HEIGHT - 300.0f * Settings.scale;
        if (this.scrollUpperBound < this.scrollLowerBound) {
            this.scrollUpperBound = this.scrollLowerBound + 100.0f * Settings.scale;
        }
    }

    public void update() {
        this.button.update();
        if (this.button.hb.clicked || InputHelper.pressedEscape) {
            InputHelper.pressedEscape = false;
            CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.MAIN_MENU;
            this.button.hide();
            CardCrawlGame.mainMenuScreen.lighten();
        }
        this.updateScrolling();
        InputHelper.justClickedLeft = false;
    }

    private void updateScrolling() {
        int y = InputHelper.mY;
        if (!this.grabbedScreen) {
            if (InputHelper.scrolledDown) {
                this.targetY += Settings.SCROLL_SPEED;
            } else if (InputHelper.scrolledUp) {
                this.targetY -= Settings.SCROLL_SPEED;
            }
            if (InputHelper.justClickedLeft) {
                this.grabbedScreen = true;
                this.grabStartY = (float)y - this.targetY;
            }
        } else if (InputHelper.isMouseDown) {
            this.targetY = (float)y - this.grabStartY;
        } else {
            this.grabbedScreen = false;
        }
        this.scrollY = MathHelper.scrollSnapLerpSpeed(this.scrollY, this.targetY);
        this.resetScrolling();
    }

    private void resetScrolling() {
        if (this.targetY < this.scrollLowerBound) {
            this.targetY = MathHelper.scrollSnapLerpSpeed(this.targetY, this.scrollLowerBound);
        } else if (this.targetY > this.scrollUpperBound) {
            this.targetY = MathHelper.scrollSnapLerpSpeed(this.targetY, this.scrollUpperBound);
        }
    }

    public void render(SpriteBatch sb) {
        FontHelper.renderSmartText(sb, FontHelper.panelNameFont, TEXT[1], 250.0f * Settings.scale, this.scrollY + 70.0f * Settings.scale, 1200.0f * Settings.scale, 30.0f, Settings.CREAM_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.panelNameTitleFont, text, 300.0f * Settings.scale, this.scrollY, 1600.0f * Settings.scale, 30.0f * Settings.scale, Settings.CREAM_COLOR);
        this.button.render(sb);
    }
}

