/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.options;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.screens.DisplayOption;
import com.megacrit.cardcrawl.vfx.RestartForChangesEffect;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;

public class Dropdown {
    private DropdownType type;
    private int index;
    private static int TMP_WIDTH = Settings.WIDTH;
    private static int TMP_HEIGHT = Settings.HEIGHT;
    private Hitbox hb;
    private float x;
    private float y;
    private float offsetX;
    private String label;

    public Dropdown(float x, float y, DropdownType type) {
        this.type = type;
        this.x = x;
        this.y = Settings.OPTION_Y + y * Settings.scale;
        this.hb = new Hitbox(200.0f * Settings.scale, 38.0f * Settings.scale);
        this.hb.move(x, this.y + -6.0f * Settings.scale);
        this.populateList();
        this.label = Integer.toString(TMP_WIDTH) + " x " + Integer.toString(TMP_HEIGHT);
        this.offsetX = FontHelper.getSmartWidth(FontHelper.tipBodyFont, this.label, 9999.0f, 0.0f) / 2.0f;
    }

    public void update() {
        this.hb.update();
        if (this.type == DropdownType.RESOLUTION && this.hb.hovered && InputHelper.justClickedLeft) {
            this.clickDropdown();
        }
    }

    private void clickDropdown() {
        ++this.index;
        if (this.type == DropdownType.RESOLUTION) {
            if (CardCrawlGame.mode == CardCrawlGame.GameMode.CHAR_SELECT) {
                CardCrawlGame.mainMenuScreen.optionPanel.effects.clear();
                CardCrawlGame.mainMenuScreen.optionPanel.effects.add(new RestartForChangesEffect());
                if (CardCrawlGame.mainMenuScreen.optionPanel.fsToggle.enabled) {
                    CardCrawlGame.mainMenuScreen.optionPanel.fsToggle.toggle();
                }
                if (CardCrawlGame.mainMenuScreen.optionPanel.wfsToggle.enabled) {
                    CardCrawlGame.mainMenuScreen.optionPanel.wfsToggle.toggle();
                }
            } else {
                AbstractDungeon.settingsScreen.panel.effects.clear();
                AbstractDungeon.settingsScreen.panel.effects.add(new RestartForChangesEffect());
                if (AbstractDungeon.settingsScreen.panel.fsToggle.enabled) {
                    AbstractDungeon.settingsScreen.panel.fsToggle.toggle();
                }
                if (AbstractDungeon.settingsScreen.panel.wfsToggle.enabled) {
                    AbstractDungeon.settingsScreen.panel.wfsToggle.toggle();
                }
            }
            if (this.index > Settings.displayOptions.size() - 1) {
                this.index = 0;
            }
        }
        TMP_WIDTH = Settings.displayOptions.get((int)this.index).width;
        TMP_HEIGHT = Settings.displayOptions.get((int)this.index).height;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter("info.displayconfig", "UTF-8");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        writer.println(Integer.toString(TMP_WIDTH));
        writer.println(Integer.toString(TMP_HEIGHT));
        writer.println(Boolean.toString(Settings.IS_FULLSCREEN));
        writer.println(Boolean.toString(Settings.IS_W_FULLSCREEN));
        writer.println(Boolean.toString(Settings.IS_V_SYNC));
        writer.close();
        Settings.SAVED_WIDTH = TMP_WIDTH;
        Settings.SAVED_HEIGHT = TMP_HEIGHT;
        this.label = Integer.toString(TMP_WIDTH) + " x " + Integer.toString(TMP_HEIGHT);
        this.offsetX = FontHelper.getSmartWidth(FontHelper.tipBodyFont, this.label, 9999.0f, 0.0f) / 2.0f;
    }

    private void populateList() {
        switch (this.type) {
            case LANGUAGE: {
                break;
            }
            case QUALITY: {
                break;
            }
            case RESOLUTION: {
                if (Settings.displayOptions == null) {
                    Settings.displayOptions = new ArrayList();
                    ArrayList<DisplayOption> availableResos = new ArrayList<DisplayOption>();
                    availableResos.add(new DisplayOption(1024, 576));
                    availableResos.add(new DisplayOption(1280, 720));
                    availableResos.add(new DisplayOption(1366, 768));
                    availableResos.add(new DisplayOption(1536, 864));
                    availableResos.add(new DisplayOption(1600, 900));
                    availableResos.add(new DisplayOption(1920, 1080));
                    availableResos.add(new DisplayOption(2560, 1440));
                    availableResos.add(new DisplayOption(3840, 2160));
                    availableResos.add(new DisplayOption(1024, 640));
                    availableResos.add(new DisplayOption(1280, 800));
                    availableResos.add(new DisplayOption(1680, 1050));
                    availableResos.add(new DisplayOption(1920, 1200));
                    availableResos.add(new DisplayOption(2560, 1600));
                    Graphics.DisplayMode[] modes = Gdx.graphics.getDisplayModes(Gdx.graphics.getPrimaryMonitor());
                    ArrayList<DisplayOption> monitorResos = new ArrayList<DisplayOption>();
                    for (Graphics.DisplayMode m : modes) {
                        DisplayOption o = new DisplayOption(m.width, m.height);
                        if (monitorResos.contains(o)) continue;
                        monitorResos.add(o);
                    }
                    for (DisplayOption o : availableResos) {
                        if (o.width > Gdx.graphics.getDisplayMode().width || o.height > Gdx.graphics.getDisplayMode().height) continue;
                        Settings.displayOptions.add(o);
                    }
                    Collections.sort(Settings.displayOptions);
                    for (int i = 0; i < Settings.displayOptions.size(); ++i) {
                        if (Settings.WIDTH != Settings.displayOptions.get((int)i).width || Settings.HEIGHT != Settings.displayOptions.get((int)i).height) continue;
                        Settings.displayIndex = i;
                        break;
                    }
                }
                this.index = Settings.displayIndex;
                break;
            }
        }
    }

    public void render(SpriteBatch sb) {
        if (this.type == DropdownType.RESOLUTION) {
            if (this.hb.hovered) {
                FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, this.label, this.x - this.offsetX, this.y, 9999.0f, 0.0f, Settings.GOLD_COLOR);
            } else {
                FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, this.label, this.x - this.offsetX, this.y, 9999.0f, 0.0f, Settings.BLUE_TEXT_COLOR);
            }
        } else {
            FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, "<NOT IMPLEMENTED>", this.x - this.offsetX - 60.0f * Settings.scale, this.y, 9999.0f, 0.0f, Settings.RED_TEXT_COLOR);
        }
        this.hb.render(sb);
    }

    public void setFullscreen(boolean borderless) {
        TMP_WIDTH = Gdx.graphics.getDisplayMode().width;
        TMP_HEIGHT = Gdx.graphics.getDisplayMode().height;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter("info.displayconfig", "UTF-8");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        writer.println(Integer.toString(TMP_WIDTH));
        writer.println(Integer.toString(TMP_HEIGHT));
        writer.println(Boolean.toString(borderless));
        writer.println(Boolean.toString(borderless));
        writer.println(Settings.IS_V_SYNC);
        writer.close();
        Settings.SAVED_WIDTH = TMP_WIDTH;
        Settings.SAVED_HEIGHT = TMP_HEIGHT;
        this.index = 0;
        for (int i = 0; i < Settings.displayOptions.size(); ++i) {
            if (!Settings.displayOptions.get(i).equals(new DisplayOption(TMP_WIDTH, TMP_HEIGHT))) continue;
            this.index = i + 1;
        }
        this.label = Integer.toString(TMP_WIDTH) + " x " + Integer.toString(TMP_HEIGHT);
        this.offsetX = FontHelper.getSmartWidth(FontHelper.tipBodyFont, this.label, 9999.0f, 0.0f) / 2.0f;
    }

    public static enum DropdownType {
        RESOLUTION,
        QUALITY,
        LANGUAGE;

    }
}

