/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.stats;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.files.FileHandle;
import com.google.gson.Gson;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.localization.AchievementStrings;
import com.megacrit.cardcrawl.monsters.thebeyond.AwakenedOne;
import com.megacrit.cardcrawl.monsters.thebeyond.TimeEater;
import com.megacrit.cardcrawl.monsters.thebottom.Hexaghost;
import com.megacrit.cardcrawl.monsters.thebottom.SlimeBoss;
import com.megacrit.cardcrawl.monsters.thebottom.TheGuardian;
import com.megacrit.cardcrawl.monsters.thecity.BronzeAutomaton;
import com.megacrit.cardcrawl.monsters.thecity.Champ;
import com.megacrit.cardcrawl.monsters.thecity.TheCollector;
import com.megacrit.cardcrawl.screens.stats.RunData;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.io.File;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CharStat {
    private static final Logger logger = LogManager.getLogger(CharStat.class.getName());
    private static final AchievementStrings achievementStrings = CardCrawlGame.languagePack.getAchievementString("CharStat");
    public static final String[] NAMES = CharStat.achievementStrings.NAMES;
    public static final String[] TEXT = CharStat.achievementStrings.TEXT;
    private Preferences pref;
    public AbstractPlayer.PlayerClass c;
    public String info;
    public String info2 = null;
    private static Gson gson = new Gson();
    private int cardsUnlocked;
    private int relicsUnlocked;
    private int cardsDiscovered;
    private int cardsToDiscover;
    public int furthestAscent;
    private int highestDaily;
    private int totalFloorsClimbed;
    private int totalCrystalsFed;
    public int numVictory;
    public int numDeath;
    public int enemyKilled;
    public int bossKilled;
    public long playTime;
    public long fastestTime;
    private ArrayList<RunData> runs = new ArrayList();
    public static final String CARD_UNLOCK = "CARD_UNLOCK";
    public static final String RELIC_UNLOCK = "RELIC_UNLOCK";
    public static final String HIGHEST_FLOOR = "HIGHEST_FLOOR";
    public static final String HIGHEST_DAILY = "HIGHEST_DAILY";
    public static final String TOTAL_FLOORS = "TOTAL_FLOORS";
    public static final String TOTAL_CRYSTALS_FED = "TOTAL_CRYSTALS_FED";
    public static final String WIN_COUNT = "WIN_COUNT";
    public static final String LOSE_COUNT = "LOSE_COUNT";
    public static final String ENEMY_KILL = "ENEMY_KILL";
    public static final String BOSS_KILL = "BOSS_KILL";
    public static final String PLAYTIME = "PLAYTIME";
    public static final String FASTEST_VICTORY = "FAST_VICTORY";

    public CharStat(ArrayList<CharStat> allChars) {
        this.cardsUnlocked = 0;
        this.relicsUnlocked = 0;
        this.furthestAscent = 0;
        this.totalFloorsClimbed = 0;
        this.totalCrystalsFed = 0;
        this.numVictory = 0;
        this.numDeath = 0;
        this.enemyKilled = 0;
        this.bossKilled = 0;
        this.playTime = 0L;
        this.fastestTime = 999999999999L;
        int highestFloorTmp = 0;
        int highestDailyTmp = 0;
        for (CharStat stat : allChars) {
            this.cardsUnlocked += stat.cardsUnlocked;
            this.relicsUnlocked += stat.relicsUnlocked;
            if (stat.furthestAscent > highestFloorTmp) {
                highestFloorTmp = this.furthestAscent = stat.furthestAscent;
            }
            if (stat.highestDaily > highestDailyTmp) {
                highestDailyTmp = this.highestDaily = stat.highestDaily;
            }
            if (stat.fastestTime < this.fastestTime && stat.fastestTime != 0L) {
                this.fastestTime = stat.fastestTime;
            }
            this.totalFloorsClimbed += stat.totalFloorsClimbed;
            this.numVictory += stat.numVictory;
            this.numDeath += stat.numDeath;
            this.enemyKilled += stat.enemyKilled;
            this.bossKilled += stat.bossKilled;
            this.playTime += stat.playTime;
            this.totalCrystalsFed += stat.totalCrystalsFed;
        }
        this.info = TEXT[0] + CharStat.formatHMSM(this.playTime) + " NL ";
        this.info = this.info + TEXT[1] + this.numVictory + " NL ";
        this.info = this.info + TEXT[2] + this.numDeath + " NL ";
        this.info = this.info + TEXT[3] + this.totalFloorsClimbed + " NL ";
        this.info = this.info + TEXT[4] + this.bossKilled + " NL ";
        this.info = this.info + TEXT[5] + this.enemyKilled + " NL ";
        this.info = this.info + TEXT[7] + UnlockTracker.getCardsSeenString() + " NL ";
        this.info = this.info + TEXT[8] + (UnlockTracker.unlockedRedCardCount + UnlockTracker.unlockedGreenCardCount) + "/" + (UnlockTracker.lockedRedCardCount + UnlockTracker.lockedGreenCardCount) + " NL ";
        this.info = this.info + TEXT[9] + UnlockTracker.getRelicsSeenString() + " NL ";
        this.info = this.info + TEXT[10] + UnlockTracker.unlockedRelicCount + "/" + UnlockTracker.lockedRelicCount + " NL ";
        this.info = this.info + TEXT[11] + this.furthestAscent + " NL ";
        if (this.fastestTime != 999999999999L) {
            this.info = this.info + TEXT[13] + CharStat.formatHMSM(this.fastestTime) + " NL ";
        }
        this.info2 = UnlockTracker.unlockPref.getInteger("GHOST", 0) == 2 ? TEXT[14] + Hexaghost.NAME + TEXT[15] : TEXT[14] + Hexaghost.NAME + TEXT[16];
        this.info2 = UnlockTracker.unlockPref.getInteger("GUARDIAN", 0) == 2 ? this.info2 + TEXT[14] + TheGuardian.NAME + TEXT[15] : this.info2 + TEXT[14] + TheGuardian.NAME + TEXT[16];
        this.info2 = UnlockTracker.unlockPref.getInteger("SLIME", 0) == 2 ? this.info2 + TEXT[14] + SlimeBoss.NAME + TEXT[15] : this.info2 + TEXT[14] + SlimeBoss.NAME + TEXT[16];
        this.info2 = UnlockTracker.unlockPref.getInteger("CHAMP", 0) == 2 ? this.info2 + TEXT[14] + Champ.NAME + TEXT[15] : this.info2 + TEXT[14] + Champ.NAME + TEXT[16];
        this.info2 = UnlockTracker.unlockPref.getInteger("AUTOMATON", 0) == 2 ? this.info2 + TEXT[14] + BronzeAutomaton.NAME + TEXT[15] : this.info2 + TEXT[14] + BronzeAutomaton.NAME + TEXT[16];
        this.info2 = UnlockTracker.unlockPref.getInteger("COLLECTOR", 0) == 2 ? this.info2 + TEXT[14] + TheCollector.NAME + TEXT[15] : this.info2 + TEXT[14] + TheCollector.NAME + TEXT[16];
        this.info2 = UnlockTracker.unlockPref.getInteger("CROW", 0) == 2 ? this.info2 + TEXT[14] + AwakenedOne.NAME + TEXT[15] : this.info2 + TEXT[14] + AwakenedOne.NAME + TEXT[16];
        this.info2 = UnlockTracker.unlockPref.getInteger("DONUT", 0) == 2 ? this.info2 + TEXT[14] + "Donu and Deca" + TEXT[15] : this.info2 + TEXT[14] + "Donu and Deca" + TEXT[16];
        this.info2 = UnlockTracker.unlockPref.getInteger("WIZARD", 0) == 2 ? this.info2 + TEXT[14] + TimeEater.NAME + TEXT[15] : this.info2 + TEXT[14] + TimeEater.NAME + TEXT[16];
    }

    public CharStat(AbstractPlayer.PlayerClass c) {
        FileHandle[] files;
        this.c = c;
        switch (c) {
            case IRONCLAD: {
                this.pref = Gdx.app.getPreferences("STSDataVagabond");
                break;
            }
            case THE_SILENT: {
                this.pref = Gdx.app.getPreferences("STSDataTheSilent");
                break;
            }
            case CROWBOT: {
                this.pref = Gdx.app.getPreferences("STSDataRobot");
            }
        }
        this.cardsUnlocked = this.calculateCardsUnlocked(c);
        this.cardsDiscovered = this.getSeenCardCount(c);
        this.cardsToDiscover = this.getCardCountForChar(c);
        this.relicsUnlocked = this.pref.getInteger(RELIC_UNLOCK, 0);
        this.furthestAscent = this.pref.getInteger(HIGHEST_FLOOR, 0);
        this.highestDaily = this.pref.getInteger(HIGHEST_DAILY, 0);
        this.totalFloorsClimbed = this.pref.getInteger(TOTAL_FLOORS, 0);
        this.totalCrystalsFed = this.pref.getInteger(TOTAL_CRYSTALS_FED, 0);
        this.numVictory = this.pref.getInteger(WIN_COUNT, 0);
        this.numDeath = this.pref.getInteger(LOSE_COUNT, 0);
        this.enemyKilled = this.pref.getInteger(ENEMY_KILL, 0);
        this.bossKilled = this.pref.getInteger(BOSS_KILL, 0);
        this.playTime = this.pref.getLong(PLAYTIME, 0L);
        this.fastestTime = this.pref.getLong(FASTEST_VICTORY, 0L);
        this.info = TEXT[0] + CharStat.formatHMSM(this.playTime) + " NL ";
        this.info = this.info + TEXT[7] + this.cardsDiscovered + "/" + this.cardsToDiscover + " NL ";
        this.info = this.info + TEXT[8] + this.cardsUnlocked + "/" + UnlockTracker.lockedRedCardCount + " NL ";
        this.info = this.info + TEXT[11] + this.furthestAscent + " NL ";
        if (this.fastestTime != 0L) {
            this.info = this.info + TEXT[13] + CharStat.formatHMSM(this.fastestTime) + " NL ";
        }
        this.info2 = TEXT[17] + this.numVictory + " NL ";
        this.info2 = this.info2 + TEXT[18] + this.numDeath + " NL ";
        this.info2 = this.info2 + TEXT[19] + this.totalFloorsClimbed + " NL ";
        this.info2 = this.info2 + TEXT[20] + this.bossKilled + " NL ";
        this.info2 = this.info2 + TEXT[21] + this.enemyKilled + " NL ";
        for (FileHandle file : files = Gdx.files.local("runs" + File.separator + c.name() + File.separator).list()) {
            this.runs.add(gson.fromJson(file.readString(), RunData.class));
        }
    }

    private int calculateCardsUnlocked(AbstractPlayer.PlayerClass c2) {
        switch (c2) {
            case IRONCLAD: {
                return UnlockTracker.unlockedRedCardCount;
            }
            case THE_SILENT: {
                return UnlockTracker.unlockedGreenCardCount;
            }
            case CROWBOT: {
                return 0;
            }
        }
        return 0;
    }

    private int getSeenCardCount(AbstractPlayer.PlayerClass c) {
        switch (c) {
            case IRONCLAD: {
                return CardLibrary.seenRedCards;
            }
            case THE_SILENT: {
                return CardLibrary.seenGreenCards;
            }
            case CROWBOT: {
                return CardLibrary.seenBlueCards;
            }
        }
        return 0;
    }

    private int getCardCountForChar(AbstractPlayer.PlayerClass c) {
        switch (c) {
            case IRONCLAD: {
                return CardLibrary.redCards;
            }
            case THE_SILENT: {
                return CardLibrary.greenCards;
            }
            case CROWBOT: {
                return CardLibrary.blueCards;
            }
        }
        return 0;
    }

    public void furthestAscent(int floor) {
        if (floor > this.furthestAscent) {
            this.furthestAscent = floor;
            this.pref.putInteger(HIGHEST_FLOOR, this.furthestAscent);
            this.pref.flush();
        }
    }

    public void highestDaily(int score) {
        if (score > this.highestDaily) {
            this.highestDaily = score;
            this.pref.putInteger(HIGHEST_DAILY, this.highestDaily);
            this.pref.flush();
        }
    }

    public void incrementCrystalsFed(int amount) {
        this.totalCrystalsFed += amount;
        this.pref.putInteger(TOTAL_CRYSTALS_FED, this.totalCrystalsFed);
        this.pref.flush();
    }

    public void incrementFloorClimbed() {
        ++this.totalFloorsClimbed;
        this.pref.putInteger(TOTAL_FLOORS, this.totalFloorsClimbed);
        this.pref.flush();
    }

    public void incrementDeath() {
        ++this.numDeath;
        this.pref.putInteger(LOSE_COUNT, this.numDeath);
        this.pref.flush();
    }

    public void incrementVictory() {
        ++this.numVictory;
        this.pref.putInteger(WIN_COUNT, this.numVictory);
        this.pref.flush();
    }

    public void incrementBossSlain() {
        ++this.bossKilled;
        this.pref.putInteger(BOSS_KILL, this.bossKilled);
        this.pref.flush();
    }

    public void incrementEnemySlain() {
        ++this.enemyKilled;
        this.pref.putInteger(ENEMY_KILL, this.enemyKilled);
        this.pref.flush();
    }

    public void incrementPlayTime(long time) {
        this.playTime += time;
        this.pref.putLong(PLAYTIME, this.playTime);
        this.pref.flush();
    }

    public static String formatHMSM(long t) {
        String res = "";
        long duration = t;
        int seconds = (int)(duration % 60L);
        int minutes = (int)((duration /= 60L) % 60L);
        int hours = (int)t / 3600;
        res = hours > 0 ? String.format("#y%02dh #y%02dm #y%02ds", hours, minutes, seconds) : String.format("#y%02dm #y%02ds", minutes, seconds);
        return res;
    }

    public void updateFastestVictory(long newTime) {
        if (newTime < this.fastestTime || this.fastestTime == 0L) {
            this.fastestTime = newTime;
            this.pref.putLong(FASTEST_VICTORY, this.fastestTime);
            this.pref.flush();
            logger.info("Fastest victory time updated to: " + this.fastestTime);
        } else {
            logger.info("Did not save fastest victory.");
        }
    }
}

