/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.shop;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AnimatedNpc;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.localization.CharacterStrings;
import com.megacrit.cardcrawl.vfx.SpeechBubble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public class Merchant {
    private static final CharacterStrings characterStrings = CardCrawlGame.languagePack.getCharacterString("Merchant");
    public static final String[] NAMES = Merchant.characterStrings.NAMES;
    public static final String[] TEXT = Merchant.characterStrings.TEXT;
    public AnimatedNpc anim;
    public static final float DRAW_X = (float)Settings.WIDTH * 0.5f + 34.0f * Settings.scale;
    public static final float DRAW_Y = AbstractDungeon.floorY - 109.0f * Settings.scale;
    public Hitbox hitbox = new Hitbox(0.0f, 0.0f, 360.0f * Settings.scale, 300.0f * Settings.scale);
    private ArrayList<AbstractCard> cards1 = new ArrayList();
    private ArrayList<AbstractCard> cards2 = new ArrayList();
    private ArrayList<String> idleMessages = new ArrayList();
    private float speechTimer = 1.5f;
    private boolean saidWelcome = false;
    private static final float MIN_IDLE_MSG_TIME = 40.0f;
    private static final float MAX_IDLE_MSG_TIME = 60.0f;
    private static final float SPEECH_DURATION = 3.0f;
    private int shopScreen = 1;
    private float modX;
    private float modY;

    public Merchant() {
        this(0.0f, 0.0f, 1);
    }

    public Merchant(float x, float y, int newShopScreen) {
        this.anim = new AnimatedNpc(1260.0f * Settings.scale, 370.0f * Settings.scale, "images/npcs/merchant/skeleton.atlas", "images/npcs/merchant/skeleton.json", "idle");
        this.cards1.add(AbstractDungeon.getCardFromPool(AbstractDungeon.rollRarity(), AbstractCard.CardType.ATTACK, true).makeCopy());
        AbstractCard addCard = AbstractDungeon.getCardFromPool(AbstractDungeon.rollRarity(), AbstractCard.CardType.ATTACK, true).makeCopy();
        while (Objects.equals(addCard.cardID, this.cards1.get((int)(this.cards1.size() - 1)).cardID)) {
            addCard = AbstractDungeon.getCardFromPool(AbstractDungeon.rollRarity(), AbstractCard.CardType.ATTACK, true).makeCopy();
        }
        this.cards1.add(addCard);
        this.cards1.add(AbstractDungeon.getCardFromPool(AbstractDungeon.rollRarity(), AbstractCard.CardType.SKILL, true).makeCopy());
        addCard = AbstractDungeon.getCardFromPool(AbstractDungeon.rollRarity(), AbstractCard.CardType.SKILL, true).makeCopy();
        while (Objects.equals(addCard.cardID, this.cards1.get((int)(this.cards1.size() - 1)).cardID)) {
            addCard = AbstractDungeon.getCardFromPool(AbstractDungeon.rollRarity(), AbstractCard.CardType.SKILL, true).makeCopy();
        }
        this.cards1.add(addCard);
        this.cards1.add(AbstractDungeon.getCardFromPool(AbstractDungeon.rollRarity(), AbstractCard.CardType.POWER, true).makeCopy());
        this.cards2.add(AbstractDungeon.getColorlessCardFromPool(AbstractCard.CardRarity.UNCOMMON).makeCopy());
        this.cards2.add(AbstractDungeon.getColorlessCardFromPool(AbstractCard.CardRarity.RARE).makeCopy());
        Collections.addAll(this.idleMessages, TEXT);
        this.speechTimer = 1.5f;
        this.modX = x;
        this.modY = y;
        this.hitbox.move(DRAW_X + (250.0f + x) * Settings.scale, DRAW_Y + (130.0f + y) * Settings.scale);
        this.shopScreen = newShopScreen;
        AbstractDungeon.shopScreen.init(this.cards1, this.cards2);
    }

    public void update() {
        this.hitbox.update();
        if (this.hitbox.hovered && InputHelper.justClickedLeft && !AbstractDungeon.isScreenUp && !AbstractDungeon.isFadingOut) {
            AbstractDungeon.overlayMenu.proceedButton.setLabel(NAMES[0]);
            this.saidWelcome = true;
            AbstractDungeon.shopScreen.open();
            this.hitbox.hovered = false;
        }
        this.speechTimer -= Gdx.graphics.getDeltaTime();
        if (this.speechTimer < 0.0f && this.shopScreen == 1) {
            String msg = this.idleMessages.get(MathUtils.random(0, this.idleMessages.size() - 1));
            if (!this.saidWelcome) {
                this.saidWelcome = true;
                this.welcomeSfx();
                msg = NAMES[1];
            } else {
                this.playMiscSfx();
            }
            if (MathUtils.randomBoolean()) {
                AbstractDungeon.effectList.add(new SpeechBubble(this.hitbox.cX - 50.0f * Settings.scale, this.hitbox.cY + 70.0f * Settings.scale, 3.0f, msg, false));
            } else {
                AbstractDungeon.effectList.add(new SpeechBubble(this.hitbox.cX + 50.0f * Settings.scale, this.hitbox.cY + 70.0f * Settings.scale, 3.0f, msg, true));
            }
            this.speechTimer = MathUtils.random(40.0f, 60.0f);
        }
    }

    private void welcomeSfx() {
        int roll = MathUtils.random(2);
        if (roll == 0) {
            CardCrawlGame.sound.play("VO_MERCHANT_3A");
        } else if (roll == 1) {
            CardCrawlGame.sound.play("VO_MERCHANT_3B");
        } else {
            CardCrawlGame.sound.play("VO_MERCHANT_3C");
        }
    }

    private void playMiscSfx() {
        int roll = MathUtils.random(5);
        if (roll == 0) {
            CardCrawlGame.sound.play("VO_MERCHANT_MA");
        } else if (roll == 1) {
            CardCrawlGame.sound.play("VO_MERCHANT_MB");
        } else if (roll == 2) {
            CardCrawlGame.sound.play("VO_MERCHANT_MC");
        } else if (roll == 3) {
            CardCrawlGame.sound.play("VO_MERCHANT_3A");
        } else if (roll == 4) {
            CardCrawlGame.sound.play("VO_MERCHANT_3B");
        } else {
            CardCrawlGame.sound.play("VO_MERCHANT_3C");
        }
    }

    public void render(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.MERCHANT_RUG_IMG, DRAW_X + this.modX, DRAW_Y + this.modY, 512.0f * Settings.scale, 512.0f * Settings.scale);
        if (this.hitbox.hovered) {
            sb.setBlendFunction(770, 1);
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, 0.3f));
            sb.draw(ImageMaster.MERCHANT_RUG_IMG, DRAW_X + this.modX, DRAW_Y + this.modY, 512.0f * Settings.scale, 512.0f * Settings.scale);
            sb.setBlendFunction(770, 771);
        }
        this.anim.render(sb);
        this.hitbox.render(sb);
    }
}

