/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.ui.panels;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.ui.panels.AbstractPanel;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import com.megacrit.cardcrawl.vfx.BobEffect;
import com.megacrit.cardcrawl.vfx.DiscardGlowEffect;
import com.megacrit.cardcrawl.vfx.ThoughtBubble;
import java.util.ArrayList;
import java.util.Iterator;

public class DiscardPilePanel
extends AbstractPanel {
    private static final TutorialStrings tutorialStrings = CardCrawlGame.languagePack.getTutorialString("Discard Tip");
    public static final String[] MSG = DiscardPilePanel.tutorialStrings.TEXT;
    public static final String[] LABEL = DiscardPilePanel.tutorialStrings.LABEL;
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("DiscardPilePanel");
    public static final String[] TEXT = DiscardPilePanel.uiStrings.TEXT;
    private static final int RAW_W = 128;
    private float scale = 1.0f;
    private static final float COUNT_CIRCLE_W = 128.0f * Settings.scale;
    private static final float DECK_X = 180.0f * Settings.scale - 64.0f;
    private static final float DECK_Y = 70.0f * Settings.scale - 64.0f;
    private static final float COUNT_X = 134.0f * Settings.scale;
    private static final float COUNT_Y = 48.0f * Settings.scale;
    private static final float COUNT_OFFSET_X = 70.0f * Settings.scale;
    private static final float COUNT_OFFSET_Y = -18.0f * Settings.scale;
    private Color glowColor = Color.WHITE.cpy();
    private float glowAlpha = 0.0f;
    private GlyphLayout gl = new GlyphLayout();
    private BobEffect bob = new BobEffect(1.0f);
    private ArrayList<DiscardGlowEffect> vfxAbove = new ArrayList();
    private ArrayList<DiscardGlowEffect> vfxBelow = new ArrayList();
    private static final float DECK_TIP_X = 1550.0f * Settings.scale;
    private static final float DECK_TIP_Y = 470.0f * Settings.scale;
    private static final float HITBOX_W = 120.0f * Settings.scale;
    private static final float HITBOX_W2 = 450.0f * Settings.scale;
    private Hitbox hitbox = new Hitbox((float)Settings.WIDTH - HITBOX_W, 0.0f, HITBOX_W, HITBOX_W);
    private Hitbox bannerHitbox = new Hitbox((float)Settings.WIDTH - HITBOX_W2, 0.0f, HITBOX_W2, HITBOX_W);

    public DiscardPilePanel() {
        super((float)Settings.WIDTH - 256.0f * Settings.scale, 0.0f, Settings.WIDTH, -300.0f * Settings.scale, 8.0f * Settings.scale, 0.0f, null, true);
    }

    @Override
    public void updatePositions() {
        super.updatePositions();
        this.bob.update();
        this.updateVfx();
        if (!this.isHidden) {
            this.hitbox.update();
            this.bannerHitbox.update();
            this.updatePop();
        }
        if (!this.hitbox.justHovered || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.NONE) {
            // empty if block
        }
        if (this.hitbox.hovered) {
            if (!AbstractDungeon.isScreenUp) {
                AbstractDungeon.overlayMenu.hoveredTip = true;
            }
            if (InputHelper.justClickedLeft && AbstractDungeon.getMonsters() != null && !AbstractDungeon.isScreenUp && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.DISCARD_VIEW && !AbstractDungeon.getMonsters().areMonstersDead()) {
                AbstractPlayer p = AbstractDungeon.player;
                if (p.discardPile.size() != 0) {
                    AbstractDungeon.discardPileViewScreen.open();
                } else {
                    AbstractDungeon.effectList.add(new ThoughtBubble(p.dialogX, p.dialogY, 3.0f, TEXT[0], true));
                }
                this.hitbox.hovered = false;
                InputHelper.justClickedLeft = false;
            }
        }
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.DISCARD_VIEW) {
            if (this.bannerHitbox.hovered && InputHelper.justClickedLeft) {
                this.hitbox.hovered = false;
                this.bannerHitbox.hovered = false;
                InputHelper.justClickedLeft = false;
                CardCrawlGame.sound.play("DECK_CLOSE");
                AbstractDungeon.closeCurrentScreen();
            } else {
                float tmp;
                this.glowAlpha += Gdx.graphics.getDeltaTime() * 3.0f;
                if (this.glowAlpha < 0.0f) {
                    this.glowAlpha *= -1.0f;
                }
                this.glowColor.a = (tmp = MathUtils.cos(this.glowAlpha)) < 0.0f ? -tmp / 2.0f : tmp / 2.0f;
            }
        }
    }

    private void updateVfx() {
        AbstractGameEffect e;
        Iterator<DiscardGlowEffect> i = this.vfxAbove.iterator();
        while (i.hasNext()) {
            e = i.next();
            e.update();
            if (!e.isDone) continue;
            i.remove();
        }
        i = this.vfxBelow.iterator();
        while (i.hasNext()) {
            e = i.next();
            e.update();
            if (!e.isDone) continue;
            i.remove();
        }
        if (this.vfxAbove.size() < 9) {
            this.vfxAbove.add(new DiscardGlowEffect(true));
        }
        if (this.vfxBelow.size() < 9) {
            this.vfxBelow.add(new DiscardGlowEffect(false));
        }
    }

    private void updatePop() {
        if (this.scale != 1.0f) {
            this.scale = MathUtils.lerp(this.scale, 1.0f, Gdx.graphics.getDeltaTime() * 8.0f);
            if (Math.abs(this.scale - 1.0f) < 0.003f) {
                this.scale = 1.0f;
            }
        }
    }

    public void pop() {
        this.scale = Settings.POP_AMOUNT;
    }

    @Override
    public void render(SpriteBatch sb) {
        if (!Settings.hideLowerElements) {
            this.renderButton(sb);
            String msg = Integer.toString(AbstractDungeon.player.discardPile.size());
            this.gl.setText(FontHelper.deckCountFont, msg);
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.DECK_COUNT_CIRCLE, this.current_x + COUNT_OFFSET_X, this.current_y + COUNT_OFFSET_Y, COUNT_CIRCLE_W, COUNT_CIRCLE_W);
            FontHelper.renderFontCentered(sb, FontHelper.deckCountFont, msg, this.current_x + COUNT_X, this.current_y + COUNT_Y);
            if (!this.isHidden) {
                this.hitbox.render(sb);
                if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.DISCARD_VIEW) {
                    this.bannerHitbox.render(sb);
                }
            }
            if (Settings.COMMON_TIP && this.hitbox.hovered && !AbstractDungeon.isScreenUp && !AbstractDungeon.getMonsters().areMonstersDead()) {
                TipHelper.renderGenericTip(DECK_TIP_X, DECK_TIP_Y, LABEL[0], MSG[0]);
            } else {
                this.hitbox.hovered = false;
            }
        }
    }

    private void renderButton(SpriteBatch sb) {
        if (this.hitbox.hovered || this.bannerHitbox.hovered && AbstractDungeon.screen == AbstractDungeon.CurrentScreen.DISCARD_VIEW) {
            this.scale = 1.2f;
        }
        for (DiscardGlowEffect e : this.vfxBelow) {
            e.render(sb, this.current_x - 1664.0f * Settings.scale, this.current_y + this.bob.y * 0.5f);
        }
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.DISCARD_BTN_BASE, this.current_x + DECK_X, this.current_y + DECK_Y + this.bob.y / 2.0f, 64.0f, 64.0f, 128.0f, 128.0f, this.scale * Settings.scale, this.scale * Settings.scale, 0.0f, 0, 0, 128, 128, false, false);
        for (DiscardGlowEffect e : this.vfxAbove) {
            e.render(sb, this.current_x - 1664.0f * Settings.scale, this.current_y + this.bob.y * 0.5f);
        }
    }
}

