/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.ui.panels;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.potions.PotionPlaceholder;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.ui.panels.PotionPopUp;

public class TopPanel {
    private static final TutorialStrings tutorialStrings = CardCrawlGame.languagePack.getTutorialString("Top Panel Tips");
    public static final String[] MSG = TopPanel.tutorialStrings.TEXT;
    public static final String[] LABEL = TopPanel.tutorialStrings.LABEL;
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("TopPanel");
    public static final String[] TEXT = TopPanel.uiStrings.TEXT;
    private static final float TIP_Y = (float)Settings.HEIGHT - 120.0f * Settings.scale;
    private static final float TIP_OFF_X = 140.0f * Settings.scale;
    private static final float ICON_W = 64.0f * Settings.scale;
    private static final float ICON_Y = (float)Settings.HEIGHT - ICON_W;
    private static final float INFO_TEXT_Y = (float)Settings.HEIGHT - 24.0f * Settings.scale;
    private String name;
    private String title;
    private Color nameColor = Color.WHITE.cpy();
    private static final float NAME_X = 24.0f * Settings.scale;
    private static final float NAME_Y = (float)Settings.HEIGHT - 20.0f * Settings.scale;
    private GlyphLayout gl = new GlyphLayout();
    private static final float TITLE_PAD = 18.0f * Settings.scale;
    private float titleX;
    private float titleY;
    private Color titleColor = Color.LIGHT_GRAY.cpy();
    private static final Color DISABLED_BTN_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.4f);
    private static final float TOP_RIGHT_TIP_X = 1550.0f * Settings.scale;
    private static final float TOP_RIGHT_PAD_X = 10.0f * Settings.scale;
    private static final float SETTINGS_X = (float)Settings.WIDTH - (ICON_W + TOP_RIGHT_PAD_X) * 1.0f;
    private float settingsAngle = 0.0f;
    private static final float DECK_X = (float)Settings.WIDTH - (ICON_W + TOP_RIGHT_PAD_X) * 2.0f;
    private float deckAngle = 0.0f;
    private static final float MAP_X = (float)Settings.WIDTH - (ICON_W + TOP_RIGHT_PAD_X) * 3.0f;
    private float mapAngle = -5.0f;
    private boolean settingsButtonDisabled = true;
    private boolean deckButtonDisabled = true;
    private boolean mapButtonDisabled = true;
    private float rotateTimer = 0.0f;
    private float hpIconX;
    private static final float HP_X_DIST = 70.0f * Settings.scale;
    private static final float HP_TIP_W = 150.0f * Settings.scale;
    private static final float HP_NUM_OFFSET_X = 60.0f * Settings.scale;
    private float goldIconX;
    private static final float GOLD_X_DIST = 182.0f * Settings.scale;
    private static final float GOLD_TIP_W = 120.0f * Settings.scale;
    private static final float GOLD_NUM_OFFSET_X = 65.0f * Settings.scale;
    public PotionPopUp potionUi = new PotionPopUp();
    private static final float POTION_PITCH_VAR = 0.1f;
    private static final float POTION_X_OFFSET = 156.0f * Settings.scale;
    public static float POTION_X;
    private float flashRedTimer = 0.0f;
    private static final float FLASH_RED_TIME = 1.0f;
    public boolean potionCombine = false;
    public int combinePotionSlot = 0;
    private static float floorX;
    private static final float FLOOR_X_OFFSET;
    public Hitbox settingsHb = new Hitbox(ICON_W, ICON_W);
    public Hitbox deckHb = new Hitbox(ICON_W, ICON_W);
    public Hitbox mapHb = new Hitbox(ICON_W, ICON_W);
    public Hitbox goldHb;
    public Hitbox hpHb;
    public Hitbox[] potionHitboxes;

    public TopPanel() {
        this.settingsHb.move(SETTINGS_X + ICON_W / 2.0f, ICON_Y + ICON_W / 2.0f);
        this.deckHb.move(DECK_X + ICON_W / 2.0f, ICON_Y + ICON_W / 2.0f);
        this.mapHb.move(MAP_X + ICON_W / 2.0f, ICON_Y + ICON_W / 2.0f);
    }

    public void setPlayerName() {
        this.name = AbstractDungeon.player.name;
        this.title = AbstractDungeon.player.title;
        this.gl.setText(FontHelper.panelNameFont, this.name);
        this.titleX = this.gl.width + NAME_X + TITLE_PAD;
        this.titleY = (float)Settings.HEIGHT - 28.0f * Settings.scale;
        this.gl.setText(FontHelper.panelNameTitleFont, this.title);
        this.hpIconX = this.titleX + this.gl.width + HP_X_DIST;
        this.goldIconX = this.hpIconX + GOLD_X_DIST;
        this.gl.reset();
        POTION_X = this.goldIconX + POTION_X_OFFSET;
        floorX = POTION_X + FLOOR_X_OFFSET;
        this.potionHitboxes = new Hitbox[3];
        for (int i = 0; i < 3; ++i) {
            this.potionHitboxes[i] = new Hitbox(Settings.POTION_W, ICON_W);
            this.potionHitboxes[i].move(POTION_X + (float)i * Settings.POTION_W, ICON_Y + ICON_W / 2.0f);
        }
        AbstractDungeon.player.adjustPotionPositions();
        this.adjustHitboxes();
    }

    public void unhoverHitboxes() {
        this.settingsHb.unhover();
        this.deckHb.unhover();
        this.mapHb.unhover();
        this.goldHb.unhover();
        this.hpHb.unhover();
        for (Hitbox hb : this.potionHitboxes) {
            hb.unhover();
        }
        for (AbstractRelic r : AbstractDungeon.player.relics) {
            r.hitbox.unhover();
        }
    }

    private void adjustHitboxes() {
        this.hpHb = new Hitbox(HP_TIP_W, ICON_W);
        this.hpHb.move(this.hpIconX + HP_TIP_W / 2.0f, ICON_Y + ICON_W / 2.0f);
        this.goldHb = new Hitbox(GOLD_TIP_W, ICON_W);
        this.goldHb.move(this.goldIconX + GOLD_TIP_W / 2.0f, ICON_Y + ICON_W / 2.0f);
    }

    public void setDungeonName(String dungeonName) {
    }

    public void update() {
        if (AbstractDungeon.screen != null && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.UNLOCK) {
            this.updateGold();
            this.updatePotions();
            this.potionUi.update();
        }
        this.hpHb.update();
        this.goldHb.update();
        this.updateButtons();
        if (AbstractDungeon.screen != null && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.UNLOCK) {
            this.updateTips();
        }
    }

    private void updateGold() {
        if (AbstractDungeon.player.gold < AbstractDungeon.player.displayGold) {
            AbstractDungeon.player.displayGold = AbstractDungeon.player.displayGold - AbstractDungeon.player.gold > 99 ? (AbstractDungeon.player.displayGold -= 10) : (AbstractDungeon.player.displayGold - AbstractDungeon.player.gold > 9 ? (AbstractDungeon.player.displayGold -= 3) : --AbstractDungeon.player.displayGold);
        } else if (AbstractDungeon.player.gold > AbstractDungeon.player.displayGold) {
            AbstractDungeon.player.displayGold = AbstractDungeon.player.gold - AbstractDungeon.player.displayGold > 99 ? (AbstractDungeon.player.displayGold += 10) : (AbstractDungeon.player.gold - AbstractDungeon.player.displayGold > 9 ? (AbstractDungeon.player.displayGold += 3) : ++AbstractDungeon.player.displayGold);
        }
    }

    public void flashRed() {
        this.flashRedTimer = 1.0f;
    }

    private void updatePotions() {
        if (this.flashRedTimer != 0.0f) {
            this.flashRedTimer -= Gdx.graphics.getDeltaTime();
            if (this.flashRedTimer < 0.0f) {
                this.flashRedTimer = 0.0f;
            }
        }
        for (Hitbox hb : this.potionHitboxes) {
            hb.update();
        }
        for (int i = 0; i < this.potionHitboxes.length; ++i) {
            AbstractPotion item = AbstractDungeon.player.potions[i];
            if (item == null || !item.isDone) continue;
            Hitbox h = this.potionHitboxes[i];
            if (h.hovered) {
                if (h.justHovered && !(item instanceof PotionPlaceholder)) {
                    if (MathUtils.randomBoolean()) {
                        CardCrawlGame.sound.play("POTION_1", 0.1f);
                    } else {
                        CardCrawlGame.sound.play("POTION_3", 0.1f);
                    }
                }
                if (InputHelper.justClickedLeft && !(AbstractDungeon.player.potions[i] instanceof PotionPlaceholder) && InputHelper.justClickedLeft && this.potionUi.isHidden && !this.potionCombine) {
                    InputHelper.justClickedLeft = false;
                    this.potionUi.open(i, AbstractDungeon.player.potions[i]);
                }
                if (item instanceof PotionPlaceholder) continue;
                item.scale = Settings.scale * 1.4f;
                continue;
            }
            if (item.scale == Settings.scale) continue;
            item.scale = MathHelper.scaleLerpSnap(item.scale, Settings.scale);
        }
    }

    public void destroyPotion(int slot) {
        AbstractDungeon.player.potions[slot] = new PotionPlaceholder(slot);
    }

    public void reservePotionSlot(int slot, AbstractPotion p) {
        if (AbstractDungeon.player.potions[slot] instanceof PotionPlaceholder) {
            ((PotionPlaceholder)AbstractDungeon.player.potions[slot]).reservedPotion = p;
        }
    }

    public void incrementPotion(int slot, AbstractPotion potion) {
        AbstractDungeon.player.potions[slot] = potion;
    }

    private void decrementPotion(int slot) {
        AbstractDungeon.player.potions[slot] = new PotionPlaceholder(slot);
    }

    private void updateButtons() {
        this.updateSettingsButtonLogic();
        this.updateDeckViewButtonLogic();
        this.updateMapButtonLogic();
        if (this.settingsHb.justHovered || this.deckHb.justHovered || this.mapHb.justHovered) {
            CardCrawlGame.sound.play("UI_HOVER");
        }
    }

    private void updateSettingsButtonLogic() {
        this.settingsButtonDisabled = false;
        if (AbstractDungeon.screen != AbstractDungeon.CurrentScreen.FTUE) {
            this.settingsHb.update();
        }
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SETTINGS) {
            this.settingsAngle += Gdx.graphics.getDeltaTime() * 300.0f;
            if (this.settingsAngle > 360.0f) {
                this.settingsAngle -= 360.0f;
            }
        } else {
            this.settingsAngle = this.settingsHb.hovered ? MathHelper.angleLerpSnap(this.settingsAngle, -90.0f) : MathHelper.angleLerpSnap(this.settingsAngle, 0.0f);
        }
        if (this.settingsHb.hovered && InputHelper.justClickedLeft && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.HAND_SELECT || InputHelper.pressedEscape && !AbstractDungeon.isScreenUp) {
            if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.GRID && AbstractDungeon.gridSelectScreen.isJustForConfirming) {
                InputHelper.pressedEscape = false;
                InputHelper.justClickedLeft = false;
                return;
            }
            InputHelper.pressedEscape = false;
            if (AbstractDungeon.isScreenUp && AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SETTINGS) {
                CardCrawlGame.sound.play("UI_CLICK_2");
                AbstractDungeon.closeCurrentScreen();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.COMBAT_REWARD) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.COMBAT_REWARD;
                AbstractDungeon.dynamicBanner.hide();
                AbstractDungeon.settingsScreen.open();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.DEATH) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.DEATH;
                AbstractDungeon.settingsScreen.open();
                AbstractDungeon.deathScreen.hide();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.BOSS_REWARD;
                AbstractDungeon.settingsScreen.open();
                AbstractDungeon.bossRelicScreen.hide();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SHOP) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.SHOP;
                AbstractDungeon.settingsScreen.open();
                AbstractDungeon.overlayMenu.cancelButton.hide();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP && !AbstractDungeon.dungeonMapScreen.dismissable) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.MAP;
                AbstractDungeon.settingsScreen.open();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MASTER_DECK_VIEW || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP) {
                if (AbstractDungeon.previousScreen != null) {
                    AbstractDungeon.screenSwap = true;
                }
                AbstractDungeon.closeCurrentScreen();
                AbstractDungeon.settingsScreen.open();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.CARD_REWARD) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.CARD_REWARD;
                AbstractDungeon.settingsScreen.open();
                AbstractDungeon.dynamicBanner.hide();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.GRID) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.GRID;
                AbstractDungeon.gridSelectScreen.hide();
                AbstractDungeon.settingsScreen.open();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.GASHA_UNLOCK) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.GASHA_UNLOCK;
                AbstractDungeon.dynamicBanner.hide();
                AbstractDungeon.settingsScreen.open();
            } else {
                AbstractDungeon.settingsScreen.open();
            }
            InputHelper.justClickedLeft = false;
        }
    }

    private void updateDeckViewButtonLogic() {
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MASTER_DECK_VIEW) {
            this.rotateTimer += Gdx.graphics.getDeltaTime() * 4.0f;
            this.deckAngle = MathHelper.angleLerpSnap(this.deckAngle, MathUtils.sin(this.rotateTimer) * 15.0f);
        } else {
            this.deckAngle = this.deckHb.hovered ? MathHelper.angleLerpSnap(this.deckAngle, 15.0f) : MathHelper.angleLerpSnap(this.deckAngle, 0.0f);
        }
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.NONE || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.COMBAT_REWARD || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MASTER_DECK_VIEW || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.DEATH || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SHOP || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SETTINGS || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.CARD_REWARD) {
            this.deckButtonDisabled = false;
            this.deckHb.update();
        } else {
            this.deckButtonDisabled = true;
            this.deckHb.hovered = false;
        }
        if (this.deckHb.hovered && InputHelper.justClickedLeft || Gdx.input.isKeyJustPressed(32)) {
            if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.COMBAT_REWARD) {
                AbstractDungeon.closeCurrentScreen();
                AbstractDungeon.deckViewScreen.open();
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.COMBAT_REWARD;
            } else if (!AbstractDungeon.isScreenUp) {
                AbstractDungeon.deckViewScreen.open();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MASTER_DECK_VIEW) {
                if (AbstractDungeon.deckViewScreen.openedDuringReward) {
                    AbstractDungeon.deckViewScreen.openedDuringReward = false;
                    AbstractDungeon.combatRewardScreen.reopen();
                } else {
                    AbstractDungeon.closeCurrentScreen();
                    CardCrawlGame.sound.play("DECK_CLOSE");
                }
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.DEATH) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.DEATH;
                AbstractDungeon.deathScreen.hide();
                AbstractDungeon.deckViewScreen.open();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.BOSS_REWARD;
                AbstractDungeon.bossRelicScreen.hide();
                AbstractDungeon.deckViewScreen.open();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SHOP) {
                AbstractDungeon.overlayMenu.cancelButton.hide();
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.SHOP;
                AbstractDungeon.deckViewScreen.open();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP && !AbstractDungeon.dungeonMapScreen.dismissable) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.MAP;
                AbstractDungeon.deckViewScreen.open();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SETTINGS || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP) {
                if (AbstractDungeon.previousScreen != null) {
                    AbstractDungeon.screenSwap = true;
                }
                AbstractDungeon.closeCurrentScreen();
                AbstractDungeon.deckViewScreen.open();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.CARD_REWARD) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.CARD_REWARD;
                AbstractDungeon.dynamicBanner.hide();
                AbstractDungeon.deckViewScreen.open();
            }
            InputHelper.justClickedLeft = false;
        }
    }

    private void updateMapButtonLogic() {
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP) {
            this.rotateTimer += Gdx.graphics.getDeltaTime() * 4.0f;
            this.mapAngle = MathHelper.angleLerpSnap(this.mapAngle, MathUtils.sin(this.rotateTimer) * 15.0f);
        } else {
            this.mapAngle = this.mapHb.hovered ? MathHelper.angleLerpSnap(this.mapAngle, 10.0f) : MathHelper.angleLerpSnap(this.mapAngle, -5.0f);
        }
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.NONE || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SETTINGS || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.DEATH || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MASTER_DECK_VIEW || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.COMBAT_REWARD || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.CARD_REWARD || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SHOP || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) {
            this.mapButtonDisabled = false;
            this.mapHb.update();
        } else {
            this.mapButtonDisabled = true;
            this.mapHb.hovered = false;
        }
        if (this.mapHb.hovered && InputHelper.justClickedLeft || Gdx.input.isKeyJustPressed(41)) {
            if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP && !AbstractDungeon.dungeonMapScreen.dismissable) {
                CardCrawlGame.sound.play("CARD_REJECT");
            } else if (!AbstractDungeon.isScreenUp) {
                AbstractDungeon.dungeonMapScreen.open(false);
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.COMBAT_REWARD) {
                AbstractDungeon.closeCurrentScreen();
                AbstractDungeon.dungeonMapScreen.open(false);
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.COMBAT_REWARD;
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.BOSS_REWARD) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.BOSS_REWARD;
                AbstractDungeon.bossRelicScreen.hide();
                AbstractDungeon.dungeonMapScreen.open(false);
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SHOP) {
                AbstractDungeon.overlayMenu.cancelButton.hide();
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.SHOP;
                AbstractDungeon.dungeonMapScreen.open(false);
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP) {
                CardCrawlGame.sound.play("MAP_CLOSE", 0.05f);
                AbstractDungeon.closeCurrentScreen();
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.DEATH) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.DEATH;
                AbstractDungeon.deathScreen.hide();
                AbstractDungeon.dungeonMapScreen.open(false);
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.SETTINGS || AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MASTER_DECK_VIEW) {
                if (AbstractDungeon.dungeonMapScreen.dismissable) {
                    if (AbstractDungeon.previousScreen != null) {
                        AbstractDungeon.screenSwap = true;
                    }
                    AbstractDungeon.closeCurrentScreen();
                    AbstractDungeon.dungeonMapScreen.open(false);
                } else {
                    AbstractDungeon.closeCurrentScreen();
                }
            } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.CARD_REWARD) {
                AbstractDungeon.previousScreen = AbstractDungeon.CurrentScreen.CARD_REWARD;
                AbstractDungeon.dynamicBanner.hide();
                AbstractDungeon.dungeonMapScreen.open(false);
            }
            InputHelper.justClickedLeft = false;
        }
    }

    private void updateTips() {
        if (!Settings.hideTopBar) {
            if (Settings.COMMON_TIP && this.hpHb.hovered) {
                TipHelper.renderGenericTip((float)InputHelper.mX - TIP_OFF_X, TIP_Y, LABEL[3], MSG[3]);
            } else if (Settings.COMMON_TIP && this.goldHb.hovered) {
                TipHelper.renderGenericTip((float)InputHelper.mX - TIP_OFF_X, TIP_Y, LABEL[4], MSG[4]);
            } else {
                this.renderPotionTips();
            }
        }
    }

    private void renderPotionTips() {
        if (!Settings.hideTopBar && this.potionUi.isHidden) {
            for (int i = 0; i < this.potionHitboxes.length; ++i) {
                if (!this.potionHitboxes[i].hovered || AbstractDungeon.player.potions[i].tips.isEmpty()) continue;
                TipHelper.queuePowerTips((float)InputHelper.mX - TIP_OFF_X, TIP_Y, AbstractDungeon.player.potions[i].tips);
            }
        }
    }

    public void render(SpriteBatch sb) {
        if (!Settings.hideTopBar) {
            sb.setColor(Color.WHITE);
            sb.draw(ImageMaster.TOP_PANEL_BAR, 0.0f, (float)Settings.HEIGHT - 128.0f * Settings.scale, (float)Settings.WIDTH, 128.0f * Settings.scale);
            FontHelper.renderFontRightTopAligned(sb, FontHelper.cardDescFont_N, "[EARLY_ACCESS_004] (11-24-2017)", (float)Settings.WIDTH - 16.0f * Settings.scale, (float)Settings.HEIGHT - 80.0f * Settings.scale, new Color(1.0f, 1.0f, 1.0f, 0.3f));
            this.renderName(sb);
            this.renderHP(sb);
            this.renderGold(sb);
            this.renderDungeonInfo(sb);
            this.renderTopRightIcons(sb);
            AbstractDungeon.player.renderRelics(sb);
            this.renderPotions(sb);
            this.potionUi.render(sb);
        }
    }

    private void renderName(SpriteBatch sb) {
        FontHelper.renderFontLeftTopAligned(sb, FontHelper.panelNameFont, this.name, NAME_X, NAME_Y, this.nameColor);
        FontHelper.renderFontLeftTopAligned(sb, FontHelper.panelNameTitleFont, this.title, this.titleX, this.titleY, this.titleColor);
    }

    private void renderHP(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.TP_HP, this.hpIconX, ICON_Y, ICON_W, ICON_W);
        FontHelper.renderFontLeftTopAligned(sb, FontHelper.topPanelInfoFont, AbstractDungeon.player.currentHealth + "/" + AbstractDungeon.player.maxHealth, this.hpIconX + HP_NUM_OFFSET_X, INFO_TEXT_Y, Color.SALMON);
        this.hpHb.render(sb);
    }

    private void renderPotions(SpriteBatch sb) {
        if (this.flashRedTimer != 0.0f) {
            sb.setColor(new Color(1.0f, 0.0f, 0.0f, this.flashRedTimer / 2.0f));
            sb.draw(ImageMaster.WHITE_SQUARE_IMG, POTION_X - 40.0f * Settings.scale, (float)Settings.HEIGHT - 64.0f * Settings.scale, 192.0f * Settings.scale, 64.0f * Settings.scale);
        }
        for (int i = 0; i < 3; ++i) {
            AbstractPotion item = AbstractDungeon.player.potions[i];
            if (item == null || !item.isObtained) continue;
            item.renderOutline(sb);
            item.render(sb);
            if (!this.potionHitboxes[i].hovered) continue;
            item.renderShiny(sb);
        }
        for (Hitbox h : this.potionHitboxes) {
            h.render(sb);
        }
    }

    private void renderGold(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.TP_GOLD, this.goldIconX, ICON_Y, ICON_W, ICON_W);
        if (AbstractDungeon.player.displayGold == AbstractDungeon.player.gold) {
            FontHelper.renderFontLeftTopAligned(sb, FontHelper.topPanelInfoFont, Integer.toString(AbstractDungeon.player.displayGold), this.goldIconX + GOLD_NUM_OFFSET_X, INFO_TEXT_Y, Settings.GOLD_COLOR);
        } else if (AbstractDungeon.player.displayGold > AbstractDungeon.player.gold) {
            FontHelper.renderFontLeftTopAligned(sb, FontHelper.cardTitleFont_N, Integer.toString(AbstractDungeon.player.displayGold), this.goldIconX + GOLD_NUM_OFFSET_X - 1.0f * Settings.scale, INFO_TEXT_Y + 1.0f * Settings.scale, Settings.RED_TEXT_COLOR);
        } else {
            FontHelper.renderFontLeftTopAligned(sb, FontHelper.cardTitleFont_N, Integer.toString(AbstractDungeon.player.displayGold), this.goldIconX + GOLD_NUM_OFFSET_X - 1.0f * Settings.scale, INFO_TEXT_Y + 1.0f * Settings.scale, Settings.GREEN_TEXT_COLOR);
        }
        this.goldHb.render(sb);
    }

    private void renderDungeonInfo(SpriteBatch sb) {
        if (AbstractDungeon.floorNum > 0) {
            FontHelper.renderFontLeftTopAligned(sb, FontHelper.panelNameTitleFont, AbstractDungeon.floorNum + TopPanel.getOrdinalNaming(AbstractDungeon.floorNum) + TEXT[0], floorX, this.titleY + 3.0f * Settings.scale, Settings.GOLD_COLOR);
        }
    }

    public static String getOrdinalNaming(int i) {
        return i % 100 == 11 || i % 100 == 12 || i % 100 == 13 ? "th" : (new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"})[i % 10];
    }

    private void renderTopRightIcons(SpriteBatch sb) {
        if (this.settingsButtonDisabled) {
            sb.setColor(DISABLED_BTN_COLOR);
        } else if (this.settingsHb.hovered) {
            sb.setColor(Color.CYAN);
            if (Settings.COMMON_TIP && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.SETTINGS) {
                TipHelper.renderGenericTip(TOP_RIGHT_TIP_X, TIP_Y, LABEL[0], MSG[0]);
            }
        } else {
            sb.setColor(Color.WHITE);
        }
        this.renderSettingsIcon(sb);
        Color tmpColor = Color.WHITE.cpy();
        if (this.deckButtonDisabled) {
            sb.setColor(DISABLED_BTN_COLOR);
            tmpColor = DISABLED_BTN_COLOR;
        } else if (this.deckHb.hovered) {
            sb.setColor(Color.CYAN);
            if (Settings.COMMON_TIP && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.MASTER_DECK_VIEW) {
                TipHelper.renderGenericTip(TOP_RIGHT_TIP_X, TIP_Y, LABEL[1], MSG[1]);
            }
        } else {
            sb.setColor(Color.WHITE);
        }
        this.renderDeckIcon(sb);
        FontHelper.renderFontRightTopAligned(sb, FontHelper.topPanelAmountFont, Integer.toString(AbstractDungeon.player.masterDeck.size()), DECK_X + 58.0f * Settings.scale, ICON_Y + 25.0f * Settings.scale, tmpColor);
        if (this.mapButtonDisabled) {
            sb.setColor(DISABLED_BTN_COLOR);
        } else if (this.mapHb.hovered) {
            sb.setColor(Color.CYAN);
            if (Settings.COMMON_TIP && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.MASTER_DECK_VIEW) {
                TipHelper.renderGenericTip(TOP_RIGHT_TIP_X, TIP_Y, LABEL[2], MSG[2]);
            }
        } else {
            sb.setColor(Color.WHITE);
        }
        this.renderMapIcon(sb);
    }

    private void renderSettingsIcon(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.SETTINGS_ICON, SETTINGS_X - 32.0f + 32.0f * Settings.scale, ICON_Y - 32.0f + 32.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, this.settingsAngle, 0, 0, 64, 64, false, false);
        if (this.settingsHb.hovered) {
            sb.setBlendFunction(770, 1);
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, 0.25f));
            sb.draw(ImageMaster.SETTINGS_ICON, SETTINGS_X - 32.0f + 32.0f * Settings.scale, ICON_Y - 32.0f + 32.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, this.settingsAngle, 0, 0, 64, 64, false, false);
            sb.setBlendFunction(770, 771);
        }
        this.settingsHb.render(sb);
    }

    private void renderDeckIcon(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.DECK_ICON, DECK_X - 32.0f + 32.0f * Settings.scale, ICON_Y - 32.0f + 32.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, this.deckAngle, 0, 0, 64, 64, false, false);
        if (this.deckHb.hovered) {
            sb.setBlendFunction(770, 1);
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, 0.25f));
            sb.draw(ImageMaster.DECK_ICON, DECK_X - 32.0f + 32.0f * Settings.scale, ICON_Y - 32.0f + 32.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, this.deckAngle, 0, 0, 64, 64, false, false);
            sb.setBlendFunction(770, 771);
        }
        this.deckHb.render(sb);
    }

    private void renderMapIcon(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.MAP_ICON, MAP_X - 32.0f + 32.0f * Settings.scale, ICON_Y - 32.0f + 32.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, this.mapAngle, 0, 0, 64, 64, false, false);
        if (this.mapHb.hovered) {
            sb.setBlendFunction(770, 1);
            sb.setColor(new Color(1.0f, 1.0f, 1.0f, 0.25f));
            sb.draw(ImageMaster.MAP_ICON, MAP_X - 32.0f + 32.0f * Settings.scale, ICON_Y - 32.0f + 32.0f * Settings.scale, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, this.mapAngle, 0, 0, 64, 64, false, false);
            sb.setBlendFunction(770, 771);
        }
        this.mapHb.render(sb);
    }

    static {
        FLOOR_X_OFFSET = 180.0f * Settings.scale;
    }
}

