/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.vfx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;

public class RestartForChangesEffect
extends AbstractGameEffect {
    private static final String msg = "Restart the game for display changes to take effect.";
    private float x;
    private float y;
    private Color color = Settings.RED_TEXT_COLOR.cpy();

    public RestartForChangesEffect() {
        this.duration = 2.0f;
        this.color.a = 0.0f;
        this.x = (float)Settings.WIDTH / 2.0f;
        this.y = (float)Settings.HEIGHT - 100.0f * Settings.scale;
        this.scale = 1.3f;
    }

    @Override
    public void update() {
        this.duration -= Gdx.graphics.getDeltaTime();
        this.scale = MathHelper.popLerpSnap(this.scale, 1.0f);
        if (this.duration < 0.0f) {
            this.duration = 0.0f;
            this.isDone = true;
        }
        this.color.a = this.duration < 1.0f ? this.duration : 1.0f;
    }

    @Override
    public void render(SpriteBatch sb) {
        FontHelper.renderFontCentered(sb, FontHelper.deckBannerFont, msg, this.x, this.y, this.color, this.scale);
    }
}

