/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.vfx.campfire;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.DailyMods;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.RestRoom;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;

public class CampfireSleepEffect
extends AbstractGameEffect {
    private static final float HEAL_AMOUNT = 0.3f;
    private static final float DUR = 3.0f;
    private boolean hasHealed = false;
    private int healAmount;
    private Color screenColor = AbstractDungeon.fadeColor.cpy();

    public CampfireSleepEffect() {
        this.duration = 3.0f;
        this.screenColor.a = 0.0f;
        ((RestRoom)AbstractDungeon.getCurrRoom()).cutFireSound();
        AbstractDungeon.overlayMenu.proceedButton.hide();
        this.healAmount = DailyMods.mods.get("Night Terrors") != false ? (int)((float)AbstractDungeon.player.maxHealth * 0.2f) : (int)((float)AbstractDungeon.player.maxHealth * 0.3f);
        if (AbstractDungeon.player.hasRelic("Regal Pillow")) {
            this.healAmount += 15;
        }
    }

    @Override
    public void update() {
        this.duration -= Gdx.graphics.getDeltaTime();
        this.updateBlackScreenColor();
        if (this.duration < 2.5f && !this.hasHealed) {
            this.playSleepJingle();
            this.hasHealed = true;
            if (AbstractDungeon.player.hasRelic("Regal Pillow")) {
                AbstractDungeon.player.getRelic("Regal Pillow").flash();
            }
            AbstractDungeon.player.heal(this.healAmount, false);
            for (AbstractRelic r : AbstractDungeon.player.relics) {
                r.onRest();
            }
        }
        if (this.duration < 1.5f) {
            if (AbstractDungeon.player.hasRelic("Dream Catcher")) {
                AbstractDungeon.player.getRelic("Dream Catcher").flash();
                AbstractDungeon.cardRewardScreen.open(AbstractDungeon.getRewardCards(), null, "Dreaming?");
            }
            this.isDone = true;
            ((RestRoom)AbstractDungeon.getCurrRoom()).fadeIn();
            AbstractRoom.waitTimer = 0.0f;
            AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
        }
    }

    private void playSleepJingle() {
        int roll = MathUtils.random(0, 2);
        switch (AbstractDungeon.id) {
            case "Exordium": {
                if (roll == 0) {
                    CardCrawlGame.sound.play("SLEEP_1-1");
                    break;
                }
                if (roll == 1) {
                    CardCrawlGame.sound.play("SLEEP_1-2");
                    break;
                }
                CardCrawlGame.sound.play("SLEEP_1-3");
                break;
            }
            case "TheCity": {
                if (roll == 0) {
                    CardCrawlGame.sound.play("SLEEP_2-1");
                    break;
                }
                if (roll == 1) {
                    CardCrawlGame.sound.play("SLEEP_2-2");
                    break;
                }
                CardCrawlGame.sound.play("SLEEP_2-3");
                break;
            }
            case "TheBeyond": {
                if (roll == 0) {
                    CardCrawlGame.sound.play("SLEEP_3-1");
                    break;
                }
                if (roll == 1) {
                    CardCrawlGame.sound.play("SLEEP_3-2");
                    break;
                }
                CardCrawlGame.sound.play("SLEEP_3-3");
                break;
            }
        }
    }

    private void updateBlackScreenColor() {
        this.screenColor.a = this.duration > 2.5f ? Interpolation.fade.apply(1.0f, 0.0f, (this.duration - 2.5f) * 2.0f) : (this.duration < 1.0f ? Interpolation.fade.apply(0.0f, 1.0f, this.duration) : 1.0f);
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setColor(this.screenColor);
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
    }
}

