/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Sentry;
import io.sentry.SentryClientFactory;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(SentryClientFactory.class);
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private volatile Boolean enabled = true;

    public SentryUncaughtExceptionHandler(Thread.UncaughtExceptionHandler defaultExceptionHandler) {
        this.defaultExceptionHandler = defaultExceptionHandler;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable thrown) {
        if (this.enabled.booleanValue()) {
            logger.trace("Uncaught exception received.");
            EventBuilder eventBuilder = new EventBuilder().withMessage(thrown.getMessage()).withLevel(Event.Level.FATAL).withSentryInterface(new ExceptionInterface(thrown));
            try {
                Sentry.capture(eventBuilder);
            }
            catch (Exception e) {
                logger.error("Error sending uncaught exception to Sentry.", e);
            }
        }
        if (this.defaultExceptionHandler != null) {
            this.defaultExceptionHandler.uncaughtException(thread, thrown);
        }
    }

    public static SentryUncaughtExceptionHandler setup() {
        logger.debug("Configuring uncaught exception handler.");
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler != null) {
            logger.debug("default UncaughtExceptionHandler class='" + currentHandler.getClass().getName() + "'");
        }
        SentryUncaughtExceptionHandler handler = new SentryUncaughtExceptionHandler(currentHandler);
        Thread.setDefaultUncaughtExceptionHandler(handler);
        return handler;
    }

    public void disable() {
        this.enabled = false;
        Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (currentHandler == this) {
            Thread.setDefaultUncaughtExceptionHandler(this.defaultExceptionHandler);
        }
    }

    public Boolean isEnabled() {
        return this.enabled;
    }
}

