/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.connection;

import io.sentry.buffer.Buffer;
import io.sentry.connection.Connection;
import io.sentry.connection.ConnectionException;
import io.sentry.connection.EventSendCallback;
import io.sentry.environment.SentryEnvironment;
import io.sentry.event.Event;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(BufferedConnection.class);
    private final ShutDownHook shutDownHook = new ShutDownHook();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    });
    private Connection actualConnection;
    private Buffer buffer;
    private boolean gracefulShutdown;
    private long shutdownTimeout;
    private volatile boolean closed = false;

    public BufferedConnection(Connection actualConnection, Buffer buffer, long flushtime, boolean gracefulShutdown, long shutdownTimeout) {
        this.actualConnection = actualConnection;
        this.buffer = buffer;
        this.gracefulShutdown = gracefulShutdown;
        this.shutdownTimeout = shutdownTimeout;
        if (gracefulShutdown) {
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        }
        Flusher flusher = new Flusher(flushtime);
        this.executorService.scheduleWithFixedDelay(flusher, flushtime, flushtime, TimeUnit.MILLISECONDS);
    }

    @Override
    public void send(Event event) {
        this.actualConnection.send(event);
        this.buffer.discard(event);
    }

    @Override
    public void addEventSendCallback(EventSendCallback eventSendCallback) {
        this.actualConnection.addEventSendCallback(eventSendCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.gracefulShutdown) {
            this.shutDownHook.enabled = false;
        }
        logger.debug("Gracefully shutting down Sentry buffer threads.");
        this.closed = true;
        this.executorService.shutdown();
        try {
            if (this.shutdownTimeout == -1L) {
                long waitBetweenLoggingMs = 5000L;
                while (!this.executorService.awaitTermination(waitBetweenLoggingMs, TimeUnit.MILLISECONDS)) {
                    logger.debug("Still waiting on buffer flusher executor to terminate.");
                }
            } else if (!this.executorService.awaitTermination(this.shutdownTimeout, TimeUnit.MILLISECONDS)) {
                logger.warn("Graceful shutdown took too much time, forcing the shutdown.");
                List<Runnable> tasks = this.executorService.shutdownNow();
                logger.warn("{} tasks failed to execute before the shutdown.", (Object)tasks.size());
            }
            logger.debug("Shutdown finished.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Graceful shutdown interrupted, forcing the shutdown.");
            List<Runnable> tasks = this.executorService.shutdownNow();
            logger.warn("{} tasks failed to execute before the shutdown.", (Object)tasks.size());
        }
        finally {
            this.actualConnection.close();
        }
    }

    public Connection wrapConnectionWithBufferWriter(final Connection connectionToWrap) {
        return new Connection(){
            final Connection wrappedConnection;
            {
                this.wrappedConnection = connectionToWrap;
            }

            @Override
            public void send(Event event) throws ConnectionException {
                try {
                    BufferedConnection.this.buffer.add(event);
                }
                catch (Exception e) {
                    logger.error("Exception occurred while attempting to add Event to buffer: ", e);
                }
                this.wrappedConnection.send(event);
            }

            @Override
            public void addEventSendCallback(EventSendCallback eventSendCallback) {
                this.wrappedConnection.addEventSendCallback(eventSendCallback);
            }

            @Override
            public void close() throws IOException {
                this.wrappedConnection.close();
            }
        };
    }

    private final class ShutDownHook
    extends Thread {
        private volatile boolean enabled = true;

        private ShutDownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.enabled) {
                return;
            }
            SentryEnvironment.startManagingThread();
            try {
                BufferedConnection.this.close();
            }
            catch (Exception e) {
                logger.error("An exception occurred while closing the connection.", e);
            }
            finally {
                SentryEnvironment.stopManagingThread();
            }
        }
    }

    private class Flusher
    implements Runnable {
        private long minAgeMillis;

        Flusher(long minAgeMillis) {
            this.minAgeMillis = minAgeMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.trace("Running Flusher");
            SentryEnvironment.startManagingThread();
            try {
                Iterator<Event> events = BufferedConnection.this.buffer.getEvents();
                while (events.hasNext() && !BufferedConnection.this.closed) {
                    long eventTime;
                    Event event = events.next();
                    long now = System.currentTimeMillis();
                    long age = now - (eventTime = event.getTimestamp().getTime());
                    if (age < this.minAgeMillis) {
                        logger.trace("Ignoring buffered event because it only " + age + "ms old.");
                        return;
                    }
                    try {
                        logger.trace("Flusher attempting to send Event: " + event.getId());
                        BufferedConnection.this.send(event);
                        logger.trace("Flusher successfully sent Event: " + event.getId());
                    }
                    catch (Exception e) {
                        logger.debug("Flusher failed to send Event: " + event.getId(), e);
                        logger.trace("Flusher run exiting early.");
                        SentryEnvironment.stopManagingThread();
                        return;
                    }
                }
                logger.trace("Flusher run exiting, no more events to send.");
            }
            finally {
                SentryEnvironment.stopManagingThread();
            }
        }
    }
}

