/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.AuthKey;
import com.sun.deploy.trace.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.net.www.protocol.http.AuthCacheValue;
import sun.net.www.protocol.http.AuthenticationInfo;

public class AuthCacheBridge {
    private AuthCacheBridge() {
    }

    public static AuthKey create(AuthCacheValue authCacheValue) {
        try {
            return new DelegateAuthCacheBridge(authCacheValue);
        }
        catch (IllegalAccessError illegalAccessError) {
            return new ReflectiveAuthCacheBridge(authCacheValue);
        }
    }

    private static class ReflectiveAuthCacheBridge
    implements AuthKey {
        private static Method getAuthTypeMethod;
        private static Method getProtocolSchemeMethod;
        private static Method getPortMethod;
        private static Method getHostMethod;
        private static Method getPathMethod;
        private static Method getPromptMethod;
        private final AuthCacheValue cacheValue;

        ReflectiveAuthCacheBridge(AuthCacheValue authCacheValue) {
            this.cacheValue = authCacheValue;
        }

        private Object invoke(Method method) {
            try {
                return method.invoke((Object)this.cacheValue, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                Trace.ignored(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Trace.ignored(invocationTargetException);
            }
            return null;
        }

        public boolean isProxy() {
            return (AuthCacheValue.Type)((Object)this.invoke(getAuthTypeMethod)) == AuthCacheValue.Type.Proxy;
        }

        public String getProtocolScheme() {
            return (String)this.invoke(getProtocolSchemeMethod);
        }

        public int getPort() {
            Integer n = (Integer)this.invoke(getPortMethod);
            return n == null ? 0 : n;
        }

        public String getHost() {
            return (String)this.invoke(getHostMethod);
        }

        public String getPath() {
            return (String)this.invoke(getPathMethod);
        }

        public String getScheme() {
            return (String)this.invoke(getProtocolSchemeMethod);
        }

        public String getPrompt() {
            return (String)this.invoke(getPromptMethod);
        }

        static {
            try {
                Class<?> clazz = Class.forName("sun.net.www.protocol.http.AuthenticationInfo");
                getAuthTypeMethod = clazz.getDeclaredMethod("getAuthType", null);
                getProtocolSchemeMethod = clazz.getDeclaredMethod("getProtocolScheme", null);
                getPortMethod = clazz.getDeclaredMethod("getPort", null);
                getHostMethod = clazz.getDeclaredMethod("getHost", null);
                getPathMethod = clazz.getDeclaredMethod("getPath", null);
                getPromptMethod = clazz.getDeclaredMethod("getPrompt", null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Trace.ignored(classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Trace.ignored(noSuchMethodException);
            }
        }
    }

    private static class DelegateAuthCacheBridge
    implements AuthKey {
        private final AuthenticationInfo cacheValue;

        DelegateAuthCacheBridge(AuthCacheValue authCacheValue) {
            this.cacheValue = (AuthenticationInfo)authCacheValue;
        }

        public boolean isProxy() {
            return this.cacheValue.getAuthType() == AuthCacheValue.Type.Proxy;
        }

        public String getProtocolScheme() {
            return this.cacheValue.getProtocolScheme();
        }

        public int getPort() {
            return this.cacheValue.getPort();
        }

        public String getHost() {
            return this.cacheValue.getHost();
        }

        public String getPath() {
            return this.cacheValue.getPath();
        }

        public String getScheme() {
            return this.cacheValue.getProtocolScheme();
        }

        public String getPrompt() {
            return this.cacheValue.getRealm();
        }
    }
}

